% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_operations.R
\name{kafka_describe_cluster}
\alias{kafka_describe_cluster}
\title{Returns a description of the MSK cluster whose Amazon Resource Name
(ARN) is specified in the request}
\usage{
kafka_describe_cluster(ClusterArn)
}
\arguments{
\item{ClusterArn}{[required] The Amazon Resource Name (ARN) that uniquely identifies the cluster.}
}
\value{
A list with the following syntax:\preformatted{list(
  ClusterInfo = list(
    ActiveOperationArn = "string",
    BrokerNodeGroupInfo = list(
      BrokerAZDistribution = "DEFAULT",
      ClientSubnets = list(
        "string"
      ),
      InstanceType = "string",
      SecurityGroups = list(
        "string"
      ),
      StorageInfo = list(
        EbsStorageInfo = list(
          VolumeSize = 123
        )
      )
    ),
    ClientAuthentication = list(
      Sasl = list(
        Scram = list(
          Enabled = TRUE|FALSE
        )
      ),
      Tls = list(
        CertificateAuthorityArnList = list(
          "string"
        )
      )
    ),
    ClusterArn = "string",
    ClusterName = "string",
    CreationTime = as.POSIXct(
      "2015-01-01"
    ),
    CurrentBrokerSoftwareInfo = list(
      ConfigurationArn = "string",
      ConfigurationRevision = 123,
      KafkaVersion = "string"
    ),
    CurrentVersion = "string",
    EncryptionInfo = list(
      EncryptionAtRest = list(
        DataVolumeKMSKeyId = "string"
      ),
      EncryptionInTransit = list(
        ClientBroker = "TLS"|"TLS_PLAINTEXT"|"PLAINTEXT",
        InCluster = TRUE|FALSE
      )
    ),
    EnhancedMonitoring = "DEFAULT"|"PER_BROKER"|"PER_TOPIC_PER_BROKER"|"PER_TOPIC_PER_PARTITION",
    OpenMonitoring = list(
      Prometheus = list(
        JmxExporter = list(
          EnabledInBroker = TRUE|FALSE
        ),
        NodeExporter = list(
          EnabledInBroker = TRUE|FALSE
        )
      )
    ),
    LoggingInfo = list(
      BrokerLogs = list(
        CloudWatchLogs = list(
          Enabled = TRUE|FALSE,
          LogGroup = "string"
        ),
        Firehose = list(
          DeliveryStream = "string",
          Enabled = TRUE|FALSE
        ),
        S3 = list(
          Bucket = "string",
          Enabled = TRUE|FALSE,
          Prefix = "string"
        )
      )
    ),
    NumberOfBrokerNodes = 123,
    State = "ACTIVE"|"CREATING"|"DELETING"|"FAILED"|"HEALING"|"MAINTENANCE"|"REBOOTING_BROKER"|"UPDATING",
    StateInfo = list(
      Code = "string",
      Message = "string"
    ),
    Tags = list(
      "string"
    ),
    ZookeeperConnectString = "string",
    ZookeeperConnectStringTls = "string"
  )
)
}
}
\description{
Returns a description of the MSK cluster whose Amazon Resource Name
(ARN) is specified in the request.
}
\section{Request syntax}{
\preformatted{svc$describe_cluster(
  ClusterArn = "string"
)
}
}

\keyword{internal}
