% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_operations.R
\name{kafka_describe_cluster_operation}
\alias{kafka_describe_cluster_operation}
\title{Returns a description of the cluster operation specified by the ARN}
\usage{
kafka_describe_cluster_operation(ClusterOperationArn)
}
\arguments{
\item{ClusterOperationArn}{[required] The Amazon Resource Name (ARN) that uniquely identifies the MSK cluster
operation.}
}
\value{
A list with the following syntax:\preformatted{list(
  ClusterOperationInfo = list(
    ClientRequestId = "string",
    ClusterArn = "string",
    CreationTime = as.POSIXct(
      "2015-01-01"
    ),
    EndTime = as.POSIXct(
      "2015-01-01"
    ),
    ErrorInfo = list(
      ErrorCode = "string",
      ErrorString = "string"
    ),
    OperationArn = "string",
    OperationState = "string",
    OperationSteps = list(
      list(
        StepInfo = list(
          StepStatus = "string"
        ),
        StepName = "string"
      )
    ),
    OperationType = "string",
    SourceClusterInfo = list(
      BrokerEBSVolumeInfo = list(
        list(
          KafkaBrokerNodeId = "string",
          VolumeSizeGB = 123
        )
      ),
      ConfigurationInfo = list(
        Arn = "string",
        Revision = 123
      ),
      NumberOfBrokerNodes = 123,
      EnhancedMonitoring = "DEFAULT"|"PER_BROKER"|"PER_TOPIC_PER_BROKER"|"PER_TOPIC_PER_PARTITION",
      OpenMonitoring = list(
        Prometheus = list(
          JmxExporter = list(
            EnabledInBroker = TRUE|FALSE
          ),
          NodeExporter = list(
            EnabledInBroker = TRUE|FALSE
          )
        )
      ),
      KafkaVersion = "string",
      LoggingInfo = list(
        BrokerLogs = list(
          CloudWatchLogs = list(
            Enabled = TRUE|FALSE,
            LogGroup = "string"
          ),
          Firehose = list(
            DeliveryStream = "string",
            Enabled = TRUE|FALSE
          ),
          S3 = list(
            Bucket = "string",
            Enabled = TRUE|FALSE,
            Prefix = "string"
          )
        )
      )
    ),
    TargetClusterInfo = list(
      BrokerEBSVolumeInfo = list(
        list(
          KafkaBrokerNodeId = "string",
          VolumeSizeGB = 123
        )
      ),
      ConfigurationInfo = list(
        Arn = "string",
        Revision = 123
      ),
      NumberOfBrokerNodes = 123,
      EnhancedMonitoring = "DEFAULT"|"PER_BROKER"|"PER_TOPIC_PER_BROKER"|"PER_TOPIC_PER_PARTITION",
      OpenMonitoring = list(
        Prometheus = list(
          JmxExporter = list(
            EnabledInBroker = TRUE|FALSE
          ),
          NodeExporter = list(
            EnabledInBroker = TRUE|FALSE
          )
        )
      ),
      KafkaVersion = "string",
      LoggingInfo = list(
        BrokerLogs = list(
          CloudWatchLogs = list(
            Enabled = TRUE|FALSE,
            LogGroup = "string"
          ),
          Firehose = list(
            DeliveryStream = "string",
            Enabled = TRUE|FALSE
          ),
          S3 = list(
            Bucket = "string",
            Enabled = TRUE|FALSE,
            Prefix = "string"
          )
        )
      )
    )
  )
)
}
}
\description{
Returns a description of the cluster operation specified by the ARN.
}
\section{Request syntax}{
\preformatted{svc$describe_cluster_operation(
  ClusterOperationArn = "string"
)
}
}

\keyword{internal}
