% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_describe_namespace}
\alias{quicksight_describe_namespace}
\title{Describes the current namespace}
\usage{
quicksight_describe_namespace(AwsAccountId, Namespace)
}
\arguments{
\item{AwsAccountId}{[required] The ID for the AWS account that contains the QuickSight namespace that
you want to describe.}

\item{Namespace}{[required] The namespace that you want to describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  Namespace = list(
    Name = "string",
    Arn = "string",
    CapacityRegion = "string",
    CreationStatus = "CREATED"|"CREATING"|"DELETING"|"RETRYABLE_FAILURE"|"NON_RETRYABLE_FAILURE",
    IdentityStore = "QUICKSIGHT",
    NamespaceError = list(
      Type = "PERMISSION_DENIED"|"INTERNAL_SERVICE_ERROR",
      Message = "string"
    )
  ),
  RequestId = "string",
  Status = 123
)
}
}
\description{
Describes the current namespace.
}
\section{Request syntax}{
\preformatted{svc$describe_namespace(
  AwsAccountId = "string",
  Namespace = "string"
)
}
}

\keyword{internal}
