% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_tables}
\alias{glue_get_tables}
\title{Retrieves the definitions of some or all of the tables in a given
Database}
\usage{
glue_get_tables(CatalogId, DatabaseName, Expression, NextToken,
  MaxResults)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the tables reside. If none is provided,
the AWS account ID is used by default.}

\item{DatabaseName}{[required] The database in the catalog whose tables to list. For Hive
compatibility, this name is entirely lowercase.}

\item{Expression}{A regular expression pattern. If present, only those tables whose names
match the pattern are returned.}

\item{NextToken}{A continuation token, included if this is a continuation call.}

\item{MaxResults}{The maximum number of tables to return in a single response.}
}
\value{
A list with the following syntax:\preformatted{list(
  TableList = list(
    list(
      Name = "string",
      DatabaseName = "string",
      Description = "string",
      Owner = "string",
      CreateTime = as.POSIXct(
        "2015-01-01"
      ),
      UpdateTime = as.POSIXct(
        "2015-01-01"
      ),
      LastAccessTime = as.POSIXct(
        "2015-01-01"
      ),
      LastAnalyzedTime = as.POSIXct(
        "2015-01-01"
      ),
      Retention = 123,
      StorageDescriptor = list(
        Columns = list(
          list(
            Name = "string",
            Type = "string",
            Comment = "string",
            Parameters = list(
              "string"
            )
          )
        ),
        Location = "string",
        InputFormat = "string",
        OutputFormat = "string",
        Compressed = TRUE|FALSE,
        NumberOfBuckets = 123,
        SerdeInfo = list(
          Name = "string",
          SerializationLibrary = "string",
          Parameters = list(
            "string"
          )
        ),
        BucketColumns = list(
          "string"
        ),
        SortColumns = list(
          list(
            Column = "string",
            SortOrder = 123
          )
        ),
        Parameters = list(
          "string"
        ),
        SkewedInfo = list(
          SkewedColumnNames = list(
            "string"
          ),
          SkewedColumnValues = list(
            "string"
          ),
          SkewedColumnValueLocationMaps = list(
            "string"
          )
        ),
        StoredAsSubDirectories = TRUE|FALSE,
        SchemaReference = list(
          SchemaId = list(
            SchemaArn = "string",
            SchemaName = "string",
            RegistryName = "string"
          ),
          SchemaVersionId = "string",
          SchemaVersionNumber = 123
        )
      ),
      PartitionKeys = list(
        list(
          Name = "string",
          Type = "string",
          Comment = "string",
          Parameters = list(
            "string"
          )
        )
      ),
      ViewOriginalText = "string",
      ViewExpandedText = "string",
      TableType = "string",
      Parameters = list(
        "string"
      ),
      CreatedBy = "string",
      IsRegisteredWithLakeFormation = TRUE|FALSE,
      TargetTable = list(
        CatalogId = "string",
        DatabaseName = "string",
        Name = "string"
      ),
      CatalogId = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves the definitions of some or all of the tables in a given
\code{Database}.
}
\section{Request syntax}{
\preformatted{svc$get_tables(
  CatalogId = "string",
  DatabaseName = "string",
  Expression = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
