# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon CloudSearch
#'
#' @description
#' Amazon CloudSearch Configuration Service
#' 
#' You use the Amazon CloudSearch configuration service to create,
#' configure, and manage search domains. Configuration service requests are
#' submitted using the AWS Query protocol. AWS Query requests are HTTP or
#' HTTPS requests submitted via HTTP GET or POST with a query parameter
#' named Action.
#' 
#' The endpoint for configuration service requests is region-specific:
#' cloudsearch.*region*.amazonaws.com. For example,
#' cloudsearch.us-east-1.amazonaws.com. For a current list of supported
#' regions and endpoints, see [Regions and
#' Endpoints](http://docs.aws.amazon.com/general/latest/gr/rande.html#cloudsearch_region).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- cloudsearch(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- cloudsearch()
#' svc$build_suggesters(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=cloudsearch_build_suggesters]{build_suggesters} \tab Indexes the search suggestions \cr
#'  \link[=cloudsearch_create_domain]{create_domain} \tab Creates a new search domain \cr
#'  \link[=cloudsearch_define_analysis_scheme]{define_analysis_scheme} \tab Configures an analysis scheme that can be applied to a text or text-array field to define language-specific text processing options\cr
#'  \link[=cloudsearch_define_expression]{define_expression} \tab Configures an Expression for the search domain \cr
#'  \link[=cloudsearch_define_index_field]{define_index_field} \tab Configures an IndexField for the search domain \cr
#'  \link[=cloudsearch_define_suggester]{define_suggester} \tab Configures a suggester for a domain \cr
#'  \link[=cloudsearch_delete_analysis_scheme]{delete_analysis_scheme} \tab Deletes an analysis scheme \cr
#'  \link[=cloudsearch_delete_domain]{delete_domain} \tab Permanently deletes a search domain and all of its data \cr
#'  \link[=cloudsearch_delete_expression]{delete_expression} \tab Removes an Expression from the search domain \cr
#'  \link[=cloudsearch_delete_index_field]{delete_index_field} \tab Removes an IndexField from the search domain \cr
#'  \link[=cloudsearch_delete_suggester]{delete_suggester} \tab Deletes a suggester \cr
#'  \link[=cloudsearch_describe_analysis_schemes]{describe_analysis_schemes} \tab Gets the analysis schemes configured for a domain \cr
#'  \link[=cloudsearch_describe_availability_options]{describe_availability_options} \tab Gets the availability options configured for a domain \cr
#'  \link[=cloudsearch_describe_domain_endpoint_options]{describe_domain_endpoint_options} \tab Returns the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS \cr
#'  \link[=cloudsearch_describe_domains]{describe_domains} \tab Gets information about the search domains owned by this account \cr
#'  \link[=cloudsearch_describe_expressions]{describe_expressions} \tab Gets the expressions configured for the search domain \cr
#'  \link[=cloudsearch_describe_index_fields]{describe_index_fields} \tab Gets information about the index fields configured for the search domain \cr
#'  \link[=cloudsearch_describe_scaling_parameters]{describe_scaling_parameters} \tab Gets the scaling parameters configured for a domain \cr
#'  \link[=cloudsearch_describe_service_access_policies]{describe_service_access_policies} \tab Gets information about the access policies that control access to the domain's document and search endpoints \cr
#'  \link[=cloudsearch_describe_suggesters]{describe_suggesters} \tab Gets the suggesters configured for a domain \cr
#'  \link[=cloudsearch_index_documents]{index_documents} \tab Tells the search domain to start indexing its documents using the latest indexing options \cr
#'  \link[=cloudsearch_list_domain_names]{list_domain_names} \tab Lists all search domains owned by an account \cr
#'  \link[=cloudsearch_update_availability_options]{update_availability_options} \tab Configures the availability options for a domain \cr
#'  \link[=cloudsearch_update_domain_endpoint_options]{update_domain_endpoint_options} \tab Updates the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS \cr
#'  \link[=cloudsearch_update_scaling_parameters]{update_scaling_parameters} \tab Configures scaling parameters for a domain \cr
#'  \link[=cloudsearch_update_service_access_policies]{update_service_access_policies} \tab Configures the access rules that control access to the domain's document and search endpoints 
#' }
#'
#' @rdname cloudsearch
#' @export
cloudsearch <- function(config = list()) {
  svc <- .cloudsearch$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.cloudsearch <- list()

.cloudsearch$operations <- list()

.cloudsearch$metadata <- list(
  service_name = "cloudsearch",
  endpoints = list("*" = list(endpoint = "cloudsearch.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "cloudsearch.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "CloudSearch",
  api_version = "2013-01-01",
  signing_name = NULL,
  json_version = "",
  target_prefix = ""
)

.cloudsearch$handlers <- new_handlers("query", "v4")

.cloudsearch$service <- function(config = list()) {
  new_service(.cloudsearch$metadata, .cloudsearch$handlers, config)
}
