% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_merge_shards}
\alias{kinesis_merge_shards}
\title{Merges two adjacent shards in a Kinesis data stream and combines them
into a single shard to reduce the stream's capacity to ingest and
transport data}
\usage{
kinesis_merge_shards(StreamName, ShardToMerge, AdjacentShardToMerge)
}
\arguments{
\item{StreamName}{[required] The name of the stream for the merge.}

\item{ShardToMerge}{[required] The shard ID of the shard to combine with the adjacent shard for the
merge.}

\item{AdjacentShardToMerge}{[required] The shard ID of the adjacent shard for the merge.}
}
\description{
Merges two adjacent shards in a Kinesis data stream and combines them
into a single shard to reduce the stream\'s capacity to ingest and
transport data. Two shards are considered adjacent if the union of the
hash key ranges for the two shards form a contiguous set with no gaps.
For example, if you have two shards, one with a hash key range of
276\\...381 and the other with a hash key range of 382\\...454, then you
could merge these two shards into a single shard that would have a hash
key range of 276\\...454. After the merge, the single child shard
receives data for all hash key values covered by the two parent shards.
}
\details{
\code{MergeShards} is called when there is a need to reduce the overall
capacity of a stream because of excess capacity that is not being used.
You must specify the shard to be merged and the adjacent shard for a
stream. For more information about merging shards, see \href{http://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-resharding-merge.html}{Merge Two Shards}
in the \emph{Amazon Kinesis Data Streams Developer Guide}.

If the stream is in the \code{ACTIVE} state, you can call \code{MergeShards}. If a
stream is in the \code{CREATING}, \code{UPDATING}, or \code{DELETING} state,
\code{MergeShards} returns a \code{ResourceInUseException}. If the specified
stream does not exist, \code{MergeShards} returns a
\code{ResourceNotFoundException}.

You can use DescribeStream to check the state of the stream, which is
returned in \code{StreamStatus}.

\code{MergeShards} is an asynchronous operation. Upon receiving a
\code{MergeShards} request, Amazon Kinesis Data Streams immediately returns a
response and sets the \code{StreamStatus} to \code{UPDATING}. After the operation
is completed, Kinesis Data Streams sets the \code{StreamStatus} to \code{ACTIVE}.
Read and write operations continue to work while the stream is in the
\code{UPDATING} state.

You use DescribeStream to determine the shard IDs that are specified in
the \code{MergeShards} request.

If you try to operate on too many streams in parallel using
CreateStream, DeleteStream, \code{MergeShards}, or SplitShard, you receive a
\code{LimitExceededException}.

\code{MergeShards} has a limit of five transactions per second per account.
}
\section{Request syntax}{
\preformatted{svc$merge_shards(
  StreamName = "string",
  ShardToMerge = "string",
  AdjacentShardToMerge = "string"
)
}
}

\keyword{internal}
