% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_run_job_flow}
\alias{emr_run_job_flow}
\title{RunJobFlow creates and starts running a new cluster (job flow)}
\usage{
emr_run_job_flow(Name, LogUri, AdditionalInfo, AmiVersion, ReleaseLabel,
  Instances, Steps, BootstrapActions, SupportedProducts,
  NewSupportedProducts, Applications, Configurations, VisibleToAllUsers,
  JobFlowRole, ServiceRole, Tags, SecurityConfiguration, AutoScalingRole,
  ScaleDownBehavior, CustomAmiId, EbsRootVolumeSize, RepoUpgradeOnBoot,
  KerberosAttributes, StepConcurrencyLevel)
}
\arguments{
\item{Name}{[required] The name of the job flow.}

\item{LogUri}{The location in Amazon S3 to write the log files of the job flow. If a
value is not provided, logs are not created.}

\item{AdditionalInfo}{A JSON string for selecting additional features.}

\item{AmiVersion}{Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR
releases 4.0 and later, \code{ReleaseLabel} is used. To specify a custom AMI,
use \code{CustomAmiID}.}

\item{ReleaseLabel}{The Amazon EMR release label, which determines the version of
open-source application packages installed on the cluster. Release
labels are in the form \code{emr-x.x.x}, where x.x.x is an Amazon EMR release
version such as \verb{emr-5.14.0}. For more information about Amazon EMR
release versions and included application versions and features, see
\url{https://docs.aws.amazon.com/emr/latest/ReleaseGuide/}. The release
label applies only to Amazon EMR releases version 4.0 and later. Earlier
versions use \code{AmiVersion}.}

\item{Instances}{[required] A specification of the number and type of Amazon EC2 instances.}

\item{Steps}{A list of steps to run.}

\item{BootstrapActions}{A list of bootstrap actions to run before Hadoop starts on the cluster
nodes.}

\item{SupportedProducts}{For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and
later, use Applications.

A list of strings that indicates third-party software to use. For more
information, see the \href{https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf}{Amazon EMR Developer Guide}.
Currently supported values are:
\itemize{
\item \"mapr-m3\" - launch the job flow using MapR M3 Edition.
\item \"mapr-m5\" - launch the job flow using MapR M5 Edition.
}}

\item{NewSupportedProducts}{For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and
later, use Applications.

A list of strings that indicates third-party software to use with the
job flow that accepts a user argument list. EMR accepts and forwards the
argument list to the corresponding installation script as bootstrap
action arguments. For more information, see \"Launch a Job Flow on the
MapR Distribution for Hadoop\" in the \href{https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf}{Amazon EMR Developer Guide}.
Supported values are:
\itemize{
\item \"mapr-m3\" - launch the cluster using MapR M3 Edition.
\item \"mapr-m5\" - launch the cluster using MapR M5 Edition.
\item \"mapr\" with the user arguments specifying \"\\--edition,m3\" or
\"\\--edition,m5\" - launch the job flow using MapR M3 or M5 Edition
respectively.
\item \"mapr-m7\" - launch the cluster using MapR M7 Edition.
\item \"hunk\" - launch the cluster with the Hunk Big Data Analtics
Platform.
\item \"hue\"- launch the cluster with Hue installed.
\item \"spark\" - launch the cluster with Apache Spark installed.
\item \"ganglia\" - launch the cluster with the Ganglia Monitoring System
installed.
}}

\item{Applications}{Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of
applications for Amazon EMR to install and configure when launching the
cluster. For a list of applications available for each Amazon EMR
release version, see the \href{https://docs.aws.amazon.com/emr/latest/ReleaseGuide/}{Amazon EMR Release Guide}.}

\item{Configurations}{For Amazon EMR releases 4.0 and later. The list of configurations
supplied for the EMR cluster you are creating.}

\item{VisibleToAllUsers}{A value of \code{true} indicates that all IAM users in the AWS account can
perform cluster actions if they have the proper IAM policy permissions.
This is the default. A value of \code{false} indicates that only the IAM user
who created the cluster can perform actions.}

\item{JobFlowRole}{Also called instance profile and EC2 role. An IAM role for an EMR
cluster. The EC2 instances of the cluster assume this role. The default
role is \code{EMR_EC2_DefaultRole}. In order to use the default role, you
must have already created it using the CLI or console.}

\item{ServiceRole}{The IAM role that will be assumed by the Amazon EMR service to access
AWS resources on your behalf.}

\item{Tags}{A list of tags to associate with a cluster and propagate to Amazon EC2
instances.}

\item{SecurityConfiguration}{The name of a security configuration to apply to the cluster.}

\item{AutoScalingRole}{An IAM role for automatic scaling policies. The default role is
\code{EMR_AutoScaling_DefaultRole}. The IAM role provides permissions that
the automatic scaling feature requires to launch and terminate EC2
instances in an instance group.}

\item{ScaleDownBehavior}{Specifies the way that individual Amazon EC2 instances terminate when an
automatic scale-in activity occurs or an instance group is resized.
\code{TERMINATE_AT_INSTANCE_HOUR} indicates that Amazon EMR terminates nodes
at the instance-hour boundary, regardless of when the request to
terminate the instance was submitted. This option is only available with
Amazon EMR 5.1.0 and later and is the default for clusters created using
that version. \code{TERMINATE_AT_TASK_COMPLETION} indicates that Amazon EMR
blacklists and drains tasks from nodes before terminating the Amazon EC2
instances, regardless of the instance-hour boundary. With either
behavior, Amazon EMR removes the least active nodes first and blocks
instance termination if it could lead to HDFS corruption.
\code{TERMINATE_AT_TASK_COMPLETION} available only in Amazon EMR version
4.1.0 and later, and is the default for versions of Amazon EMR earlier
than 5.1.0.}

\item{CustomAmiId}{Available only in Amazon EMR version 5.7.0 and later. The ID of a custom
Amazon EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when
it launches cluster EC2 instances. For more information about custom
AMIs in Amazon EMR, see \href{https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html}{Using a Custom AMI}
in the \emph{Amazon EMR Management Guide}. If omitted, the cluster uses the
base Linux AMI for the \code{ReleaseLabel} specified. For Amazon EMR versions
2.x and 3.x, use \code{AmiVersion} instead.

For information about creating a custom AMI, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html}{Creating an Amazon EBS-Backed Linux AMI}
in the \emph{Amazon Elastic Compute Cloud User Guide for Linux Instances}.
For information about finding an AMI ID, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html}{Finding a Linux AMI}.}

\item{EbsRootVolumeSize}{The size, in GiB, of the EBS root device volume of the Linux AMI that is
used for each EC2 instance. Available in Amazon EMR version 4.x and
later.}

\item{RepoUpgradeOnBoot}{Applies only when \code{CustomAmiID} is used. Specifies which updates from
the Amazon Linux AMI package repositories to apply automatically when
the instance boots using the AMI. If omitted, the default is \code{SECURITY},
which indicates that only security updates are applied. If \code{NONE} is
specified, no updates are applied, and all updates must be applied
manually.}

\item{KerberosAttributes}{Attributes for Kerberos configuration when Kerberos authentication is
enabled using a security configuration. For more information see \href{https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html}{Use Kerberos Authentication}
in the \emph{EMR Management Guide}.}

\item{StepConcurrencyLevel}{Specifies the number of steps that can be executed concurrently. The
default value is \code{1}. The maximum value is \code{256}.}
}
\description{
RunJobFlow creates and starts running a new cluster (job flow). The
cluster runs the steps specified. After the steps complete, the cluster
stops and the HDFS partition is lost. To prevent loss of data, configure
the last step of the job flow to store results in Amazon S3. If the
JobFlowInstancesConfig \code{KeepJobFlowAliveWhenNoSteps} parameter is set to
\code{TRUE}, the cluster transitions to the WAITING state rather than
shutting down after the steps have completed.
}
\details{
For additional protection, you can set the JobFlowInstancesConfig
\code{TerminationProtected} parameter to \code{TRUE} to lock the cluster and
prevent it from being terminated by API call, user intervention, or in
the event of a job flow error.

A maximum of 256 steps are allowed in each job flow.

If your cluster is long-running (such as a Hive data warehouse) or
complex, you may require more than 256 steps to process your data. You
can bypass the 256-step limitation in various ways, including using the
SSH shell to connect to the master node and submitting queries directly
to the software running on the master node, such as Hive and Hadoop. For
more information on how to do this, see \href{https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html}{Add More than 256 Steps to a Cluster}
in the \emph{Amazon EMR Management Guide}.

For long running clusters, we recommend that you periodically store your
results.

The instance fleets configuration is available only in Amazon EMR
versions 4.8.0 and later, excluding 5.0.x versions. The RunJobFlow
request can contain InstanceFleets parameters or InstanceGroups
parameters, but not both.
}
\section{Request syntax}{
\preformatted{svc$run_job_flow(
  Name = "string",
  LogUri = "string",
  AdditionalInfo = "string",
  AmiVersion = "string",
  ReleaseLabel = "string",
  Instances = list(
    MasterInstanceType = "string",
    SlaveInstanceType = "string",
    InstanceCount = 123,
    InstanceGroups = list(
      list(
        Name = "string",
        Market = "ON_DEMAND"|"SPOT",
        InstanceRole = "MASTER"|"CORE"|"TASK",
        BidPrice = "string",
        InstanceType = "string",
        InstanceCount = 123,
        Configurations = list(
          list(
            Classification = "string",
            Configurations = list(),
            Properties = list(
              "string"
            )
          )
        ),
        EbsConfiguration = list(
          EbsBlockDeviceConfigs = list(
            list(
              VolumeSpecification = list(
                VolumeType = "string",
                Iops = 123,
                SizeInGB = 123
              ),
              VolumesPerInstance = 123
            )
          ),
          EbsOptimized = TRUE|FALSE
        ),
        AutoScalingPolicy = list(
          Constraints = list(
            MinCapacity = 123,
            MaxCapacity = 123
          ),
          Rules = list(
            list(
              Name = "string",
              Description = "string",
              Action = list(
                Market = "ON_DEMAND"|"SPOT",
                SimpleScalingPolicyConfiguration = list(
                  AdjustmentType = "CHANGE_IN_CAPACITY"|"PERCENT_CHANGE_IN_CAPACITY"|"EXACT_CAPACITY",
                  ScalingAdjustment = 123,
                  CoolDown = 123
                )
              ),
              Trigger = list(
                CloudWatchAlarmDefinition = list(
                  ComparisonOperator = "GREATER_THAN_OR_EQUAL"|"GREATER_THAN"|"LESS_THAN"|"LESS_THAN_OR_EQUAL",
                  EvaluationPeriods = 123,
                  MetricName = "string",
                  Namespace = "string",
                  Period = 123,
                  Statistic = "SAMPLE_COUNT"|"AVERAGE"|"SUM"|"MINIMUM"|"MAXIMUM",
                  Threshold = 123.0,
                  Unit = "NONE"|"SECONDS"|"MICRO_SECONDS"|"MILLI_SECONDS"|"BYTES"|"KILO_BYTES"|"MEGA_BYTES"|"GIGA_BYTES"|"TERA_BYTES"|"BITS"|"KILO_BITS"|"MEGA_BITS"|"GIGA_BITS"|"TERA_BITS"|"PERCENT"|"COUNT"|"BYTES_PER_SECOND"|"KILO_BYTES_PER_SECOND"|"MEGA_BYTES_PER_SECOND"|"GIGA_BYTES_PER_SECOND"|"TERA_BYTES_PER_SECOND"|"BITS_PER_SECOND"|"KILO_BITS_PER_SECOND"|"MEGA_BITS_PER_SECOND"|"GIGA_BITS_PER_SECOND"|"TERA_BITS_PER_SECOND"|"COUNT_PER_SECOND",
                  Dimensions = list(
                    list(
                      Key = "string",
                      Value = "string"
                    )
                  )
                )
              )
            )
          )
        )
      )
    ),
    InstanceFleets = list(
      list(
        Name = "string",
        InstanceFleetType = "MASTER"|"CORE"|"TASK",
        TargetOnDemandCapacity = 123,
        TargetSpotCapacity = 123,
        InstanceTypeConfigs = list(
          list(
            InstanceType = "string",
            WeightedCapacity = 123,
            BidPrice = "string",
            BidPriceAsPercentageOfOnDemandPrice = 123.0,
            EbsConfiguration = list(
              EbsBlockDeviceConfigs = list(
                list(
                  VolumeSpecification = list(
                    VolumeType = "string",
                    Iops = 123,
                    SizeInGB = 123
                  ),
                  VolumesPerInstance = 123
                )
              ),
              EbsOptimized = TRUE|FALSE
            ),
            Configurations = list(
              list(
                Classification = "string",
                Configurations = list(),
                Properties = list(
                  "string"
                )
              )
            )
          )
        ),
        LaunchSpecifications = list(
          SpotSpecification = list(
            TimeoutDurationMinutes = 123,
            TimeoutAction = "SWITCH_TO_ON_DEMAND"|"TERMINATE_CLUSTER",
            BlockDurationMinutes = 123
          )
        )
      )
    ),
    Ec2KeyName = "string",
    Placement = list(
      AvailabilityZone = "string",
      AvailabilityZones = list(
        "string"
      )
    ),
    KeepJobFlowAliveWhenNoSteps = TRUE|FALSE,
    TerminationProtected = TRUE|FALSE,
    HadoopVersion = "string",
    Ec2SubnetId = "string",
    Ec2SubnetIds = list(
      "string"
    ),
    EmrManagedMasterSecurityGroup = "string",
    EmrManagedSlaveSecurityGroup = "string",
    ServiceAccessSecurityGroup = "string",
    AdditionalMasterSecurityGroups = list(
      "string"
    ),
    AdditionalSlaveSecurityGroups = list(
      "string"
    )
  ),
  Steps = list(
    list(
      Name = "string",
      ActionOnFailure = "TERMINATE_JOB_FLOW"|"TERMINATE_CLUSTER"|"CANCEL_AND_WAIT"|"CONTINUE",
      HadoopJarStep = list(
        Properties = list(
          list(
            Key = "string",
            Value = "string"
          )
        ),
        Jar = "string",
        MainClass = "string",
        Args = list(
          "string"
        )
      )
    )
  ),
  BootstrapActions = list(
    list(
      Name = "string",
      ScriptBootstrapAction = list(
        Path = "string",
        Args = list(
          "string"
        )
      )
    )
  ),
  SupportedProducts = list(
    "string"
  ),
  NewSupportedProducts = list(
    list(
      Name = "string",
      Args = list(
        "string"
      )
    )
  ),
  Applications = list(
    list(
      Name = "string",
      Version = "string",
      Args = list(
        "string"
      ),
      AdditionalInfo = list(
        "string"
      )
    )
  ),
  Configurations = list(
    list(
      Classification = "string",
      Configurations = list(),
      Properties = list(
        "string"
      )
    )
  ),
  VisibleToAllUsers = TRUE|FALSE,
  JobFlowRole = "string",
  ServiceRole = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  SecurityConfiguration = "string",
  AutoScalingRole = "string",
  ScaleDownBehavior = "TERMINATE_AT_INSTANCE_HOUR"|"TERMINATE_AT_TASK_COMPLETION",
  CustomAmiId = "string",
  EbsRootVolumeSize = 123,
  RepoUpgradeOnBoot = "SECURITY"|"NONE",
  KerberosAttributes = list(
    Realm = "string",
    KdcAdminPassword = "string",
    CrossRealmTrustPrincipalPassword = "string",
    ADDomainJoinUser = "string",
    ADDomainJoinPassword = "string"
  ),
  StepConcurrencyLevel = 123
)
}
}

\keyword{internal}
