% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_start_job_run}
\alias{glue_start_job_run}
\title{Starts a job run using a job definition}
\usage{
glue_start_job_run(JobName, JobRunId, Arguments, AllocatedCapacity,
  Timeout, MaxCapacity, SecurityConfiguration, NotificationProperty,
  WorkerType, NumberOfWorkers)
}
\arguments{
\item{JobName}{[required] The name of the job definition to use.}

\item{JobRunId}{The ID of a previous \code{JobRun} to retry.}

\item{Arguments}{The job arguments specifically for this run. For this job run, they
replace the default arguments set in the job definition itself.

You can specify arguments here that your own job-execution script
consumes, as well as arguments that AWS Glue itself consumes.

For information about how to specify and consume your own Job arguments,
see the \href{https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html}{Calling AWS Glue APIs in Python}
topic in the developer guide.

For information about the key-value pairs that AWS Glue consumes to set
up your job, see the \href{https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html}{Special Parameters Used by AWS Glue}
topic in the developer guide.}

\item{AllocatedCapacity}{This field is deprecated. Use \code{MaxCapacity} instead.

The number of AWS Glue data processing units (DPUs) to allocate to this
JobRun. From 2 to 100 DPUs can be allocated; the default is 10. A DPU is
a relative measure of processing power that consists of 4 vCPUs of
compute capacity and 16 GB of memory. For more information, see the AWS
Glue pricing page.}

\item{Timeout}{The \code{JobRun} timeout in minutes. This is the maximum time that a job run
can consume resources before it is terminated and enters \code{TIMEOUT}
status. The default is 2,880 minutes (48 hours). This overrides the
timeout value set in the parent job.}

\item{MaxCapacity}{The number of AWS Glue data processing units (DPUs) that can be
allocated when this job runs. A DPU is a relative measure of processing
power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
For more information, see the AWS Glue pricing page.

Do not set \verb{Max Capacity} if using \code{WorkerType} and \code{NumberOfWorkers}.

The value that can be allocated for \code{MaxCapacity} depends on whether you
are running a Python shell job, or an Apache Spark ETL job:
\itemize{
\item When you specify a Python shell job
(\code{JobCommand.Name}=\"pythonshell\"), you can allocate either 0.0625
or 1 DPU. The default is 0.0625 DPU.
\item When you specify an Apache Spark ETL job
(\code{JobCommand.Name}=\"glueetl\"), you can allocate from 2 to 100
DPUs. The default is 10 DPUs. This job type cannot have a fractional
DPU allocation.
}}

\item{SecurityConfiguration}{The name of the \code{SecurityConfiguration} structure to be used with this
job run.}

\item{NotificationProperty}{Specifies configuration properties of a job run notification.}

\item{WorkerType}{The type of predefined worker that is allocated when a job runs. Accepts
a value of Standard, G.1X, or G.2X.
\itemize{
\item For the \code{Standard} worker type, each worker provides 4 vCPU, 16 GB
of memory and a 50GB disk, and 2 executors per worker.
\item For the \code{G.1X} worker type, each worker provides 4 vCPU, 16 GB of
memory and a 64GB disk, and 1 executor per worker.
\item For the \code{G.2X} worker type, each worker provides 8 vCPU, 32 GB of
memory and a 128GB disk, and 1 executor per worker.
}}

\item{NumberOfWorkers}{The number of workers of a defined \code{workerType} that are allocated when
a job runs.

The maximum number of workers you can define are 299 for \code{G.1X}, and 149
for \code{G.2X}.}
}
\description{
Starts a job run using a job definition.
}
\section{Request syntax}{
\preformatted{svc$start_job_run(
  JobName = "string",
  JobRunId = "string",
  Arguments = list(
    "string"
  ),
  AllocatedCapacity = 123,
  Timeout = 123,
  MaxCapacity = 123.0,
  SecurityConfiguration = "string",
  NotificationProperty = list(
    NotifyDelayAfter = 123
  ),
  WorkerType = "Standard"|"G.1X"|"G.2X",
  NumberOfWorkers = 123
)
}
}

\keyword{internal}
