% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firehose_operations.R
\name{firehose_update_destination}
\alias{firehose_update_destination}
\title{Updates the specified destination of the specified delivery stream}
\usage{
firehose_update_destination(DeliveryStreamName,
  CurrentDeliveryStreamVersionId, DestinationId, S3DestinationUpdate,
  ExtendedS3DestinationUpdate, RedshiftDestinationUpdate,
  ElasticsearchDestinationUpdate, SplunkDestinationUpdate)
}
\arguments{
\item{DeliveryStreamName}{[required] The name of the delivery stream.}

\item{CurrentDeliveryStreamVersionId}{[required] Obtain this value from the \code{VersionId} result of
DeliveryStreamDescription. This value is required, and helps the service
perform conditional operations. For example, if there is an interleaving
update and this value is null, then the update destination fails. After
the update is successful, the \code{VersionId} value is updated. The service
then performs a merge of the old configuration with the new
configuration.}

\item{DestinationId}{[required] The ID of the destination.}

\item{S3DestinationUpdate}{[Deprecated] Describes an update for a destination in Amazon S3.}

\item{ExtendedS3DestinationUpdate}{Describes an update for a destination in Amazon S3.}

\item{RedshiftDestinationUpdate}{Describes an update for a destination in Amazon Redshift.}

\item{ElasticsearchDestinationUpdate}{Describes an update for a destination in Amazon ES.}

\item{SplunkDestinationUpdate}{Describes an update for a destination in Splunk.}
}
\description{
Updates the specified destination of the specified delivery stream.
}
\details{
Use this operation to change the destination type (for example, to
replace the Amazon S3 destination with Amazon Redshift) or change the
parameters associated with a destination (for example, to change the
bucket name of the Amazon S3 destination). The update might not occur
immediately. The target delivery stream remains active while the
configurations are updated, so data writes to the delivery stream can
continue during this process. The updated configurations are usually
effective within a few minutes.

Switching between Amazon ES and other services is not supported. For an
Amazon ES destination, you can only update to another Amazon ES
destination.

If the destination type is the same, Kinesis Data Firehose merges the
configuration parameters specified with the destination configuration
that already exists on the delivery stream. If any of the parameters are
not specified in the call, the existing values are retained. For
example, in the Amazon S3 destination, if EncryptionConfiguration is not
specified, then the existing \code{EncryptionConfiguration} is maintained on
the destination.

If the destination type is not the same, for example, changing the
destination from Amazon S3 to Amazon Redshift, Kinesis Data Firehose
does not merge any parameters. In this case, all parameters must be
specified.

Kinesis Data Firehose uses \code{CurrentDeliveryStreamVersionId} to avoid
race conditions and conflicting merges. This is a required field, and
the service updates the configuration only if the existing configuration
has a version ID that matches. After the update is applied successfully,
the version ID is updated, and can be retrieved using
DescribeDeliveryStream. Use the new version ID to set
\code{CurrentDeliveryStreamVersionId} in the next call.
}
\section{Request syntax}{
\preformatted{svc$update_destination(
  DeliveryStreamName = "string",
  CurrentDeliveryStreamVersionId = "string",
  DestinationId = "string",
  S3DestinationUpdate = list(
    RoleARN = "string",
    BucketARN = "string",
    Prefix = "string",
    ErrorOutputPrefix = "string",
    BufferingHints = list(
      SizeInMBs = 123,
      IntervalInSeconds = 123
    ),
    CompressionFormat = "UNCOMPRESSED"|"GZIP"|"ZIP"|"Snappy"|"HADOOP_SNAPPY",
    EncryptionConfiguration = list(
      NoEncryptionConfig = "NoEncryption",
      KMSEncryptionConfig = list(
        AWSKMSKeyARN = "string"
      )
    ),
    CloudWatchLoggingOptions = list(
      Enabled = TRUE|FALSE,
      LogGroupName = "string",
      LogStreamName = "string"
    )
  ),
  ExtendedS3DestinationUpdate = list(
    RoleARN = "string",
    BucketARN = "string",
    Prefix = "string",
    ErrorOutputPrefix = "string",
    BufferingHints = list(
      SizeInMBs = 123,
      IntervalInSeconds = 123
    ),
    CompressionFormat = "UNCOMPRESSED"|"GZIP"|"ZIP"|"Snappy"|"HADOOP_SNAPPY",
    EncryptionConfiguration = list(
      NoEncryptionConfig = "NoEncryption",
      KMSEncryptionConfig = list(
        AWSKMSKeyARN = "string"
      )
    ),
    CloudWatchLoggingOptions = list(
      Enabled = TRUE|FALSE,
      LogGroupName = "string",
      LogStreamName = "string"
    ),
    ProcessingConfiguration = list(
      Enabled = TRUE|FALSE,
      Processors = list(
        list(
          Type = "Lambda",
          Parameters = list(
            list(
              ParameterName = "LambdaArn"|"NumberOfRetries"|"RoleArn"|"BufferSizeInMBs"|"BufferIntervalInSeconds",
              ParameterValue = "string"
            )
          )
        )
      )
    ),
    S3BackupMode = "Disabled"|"Enabled",
    S3BackupUpdate = list(
      RoleARN = "string",
      BucketARN = "string",
      Prefix = "string",
      ErrorOutputPrefix = "string",
      BufferingHints = list(
        SizeInMBs = 123,
        IntervalInSeconds = 123
      ),
      CompressionFormat = "UNCOMPRESSED"|"GZIP"|"ZIP"|"Snappy"|"HADOOP_SNAPPY",
      EncryptionConfiguration = list(
        NoEncryptionConfig = "NoEncryption",
        KMSEncryptionConfig = list(
          AWSKMSKeyARN = "string"
        )
      ),
      CloudWatchLoggingOptions = list(
        Enabled = TRUE|FALSE,
        LogGroupName = "string",
        LogStreamName = "string"
      )
    ),
    DataFormatConversionConfiguration = list(
      SchemaConfiguration = list(
        RoleARN = "string",
        CatalogId = "string",
        DatabaseName = "string",
        TableName = "string",
        Region = "string",
        VersionId = "string"
      ),
      InputFormatConfiguration = list(
        Deserializer = list(
          OpenXJsonSerDe = list(
            ConvertDotsInJsonKeysToUnderscores = TRUE|FALSE,
            CaseInsensitive = TRUE|FALSE,
            ColumnToJsonKeyMappings = list(
              "string"
            )
          ),
          HiveJsonSerDe = list(
            TimestampFormats = list(
              "string"
            )
          )
        )
      ),
      OutputFormatConfiguration = list(
        Serializer = list(
          ParquetSerDe = list(
            BlockSizeBytes = 123,
            PageSizeBytes = 123,
            Compression = "UNCOMPRESSED"|"GZIP"|"SNAPPY",
            EnableDictionaryCompression = TRUE|FALSE,
            MaxPaddingBytes = 123,
            WriterVersion = "V1"|"V2"
          ),
          OrcSerDe = list(
            StripeSizeBytes = 123,
            BlockSizeBytes = 123,
            RowIndexStride = 123,
            EnablePadding = TRUE|FALSE,
            PaddingTolerance = 123.0,
            Compression = "NONE"|"ZLIB"|"SNAPPY",
            BloomFilterColumns = list(
              "string"
            ),
            BloomFilterFalsePositiveProbability = 123.0,
            DictionaryKeyThreshold = 123.0,
            FormatVersion = "V0_11"|"V0_12"
          )
        )
      ),
      Enabled = TRUE|FALSE
    )
  ),
  RedshiftDestinationUpdate = list(
    RoleARN = "string",
    ClusterJDBCURL = "string",
    CopyCommand = list(
      DataTableName = "string",
      DataTableColumns = "string",
      CopyOptions = "string"
    ),
    Username = "string",
    Password = "string",
    RetryOptions = list(
      DurationInSeconds = 123
    ),
    S3Update = list(
      RoleARN = "string",
      BucketARN = "string",
      Prefix = "string",
      ErrorOutputPrefix = "string",
      BufferingHints = list(
        SizeInMBs = 123,
        IntervalInSeconds = 123
      ),
      CompressionFormat = "UNCOMPRESSED"|"GZIP"|"ZIP"|"Snappy"|"HADOOP_SNAPPY",
      EncryptionConfiguration = list(
        NoEncryptionConfig = "NoEncryption",
        KMSEncryptionConfig = list(
          AWSKMSKeyARN = "string"
        )
      ),
      CloudWatchLoggingOptions = list(
        Enabled = TRUE|FALSE,
        LogGroupName = "string",
        LogStreamName = "string"
      )
    ),
    ProcessingConfiguration = list(
      Enabled = TRUE|FALSE,
      Processors = list(
        list(
          Type = "Lambda",
          Parameters = list(
            list(
              ParameterName = "LambdaArn"|"NumberOfRetries"|"RoleArn"|"BufferSizeInMBs"|"BufferIntervalInSeconds",
              ParameterValue = "string"
            )
          )
        )
      )
    ),
    S3BackupMode = "Disabled"|"Enabled",
    S3BackupUpdate = list(
      RoleARN = "string",
      BucketARN = "string",
      Prefix = "string",
      ErrorOutputPrefix = "string",
      BufferingHints = list(
        SizeInMBs = 123,
        IntervalInSeconds = 123
      ),
      CompressionFormat = "UNCOMPRESSED"|"GZIP"|"ZIP"|"Snappy"|"HADOOP_SNAPPY",
      EncryptionConfiguration = list(
        NoEncryptionConfig = "NoEncryption",
        KMSEncryptionConfig = list(
          AWSKMSKeyARN = "string"
        )
      ),
      CloudWatchLoggingOptions = list(
        Enabled = TRUE|FALSE,
        LogGroupName = "string",
        LogStreamName = "string"
      )
    ),
    CloudWatchLoggingOptions = list(
      Enabled = TRUE|FALSE,
      LogGroupName = "string",
      LogStreamName = "string"
    )
  ),
  ElasticsearchDestinationUpdate = list(
    RoleARN = "string",
    DomainARN = "string",
    ClusterEndpoint = "string",
    IndexName = "string",
    TypeName = "string",
    IndexRotationPeriod = "NoRotation"|"OneHour"|"OneDay"|"OneWeek"|"OneMonth",
    BufferingHints = list(
      IntervalInSeconds = 123,
      SizeInMBs = 123
    ),
    RetryOptions = list(
      DurationInSeconds = 123
    ),
    S3Update = list(
      RoleARN = "string",
      BucketARN = "string",
      Prefix = "string",
      ErrorOutputPrefix = "string",
      BufferingHints = list(
        SizeInMBs = 123,
        IntervalInSeconds = 123
      ),
      CompressionFormat = "UNCOMPRESSED"|"GZIP"|"ZIP"|"Snappy"|"HADOOP_SNAPPY",
      EncryptionConfiguration = list(
        NoEncryptionConfig = "NoEncryption",
        KMSEncryptionConfig = list(
          AWSKMSKeyARN = "string"
        )
      ),
      CloudWatchLoggingOptions = list(
        Enabled = TRUE|FALSE,
        LogGroupName = "string",
        LogStreamName = "string"
      )
    ),
    ProcessingConfiguration = list(
      Enabled = TRUE|FALSE,
      Processors = list(
        list(
          Type = "Lambda",
          Parameters = list(
            list(
              ParameterName = "LambdaArn"|"NumberOfRetries"|"RoleArn"|"BufferSizeInMBs"|"BufferIntervalInSeconds",
              ParameterValue = "string"
            )
          )
        )
      )
    ),
    CloudWatchLoggingOptions = list(
      Enabled = TRUE|FALSE,
      LogGroupName = "string",
      LogStreamName = "string"
    )
  ),
  SplunkDestinationUpdate = list(
    HECEndpoint = "string",
    HECEndpointType = "Raw"|"Event",
    HECToken = "string",
    HECAcknowledgmentTimeoutInSeconds = 123,
    RetryOptions = list(
      DurationInSeconds = 123
    ),
    S3BackupMode = "FailedEventsOnly"|"AllEvents",
    S3Update = list(
      RoleARN = "string",
      BucketARN = "string",
      Prefix = "string",
      ErrorOutputPrefix = "string",
      BufferingHints = list(
        SizeInMBs = 123,
        IntervalInSeconds = 123
      ),
      CompressionFormat = "UNCOMPRESSED"|"GZIP"|"ZIP"|"Snappy"|"HADOOP_SNAPPY",
      EncryptionConfiguration = list(
        NoEncryptionConfig = "NoEncryption",
        KMSEncryptionConfig = list(
          AWSKMSKeyARN = "string"
        )
      ),
      CloudWatchLoggingOptions = list(
        Enabled = TRUE|FALSE,
        LogGroupName = "string",
        LogStreamName = "string"
      )
    ),
    ProcessingConfiguration = list(
      Enabled = TRUE|FALSE,
      Processors = list(
        list(
          Type = "Lambda",
          Parameters = list(
            list(
              ParameterName = "LambdaArn"|"NumberOfRetries"|"RoleArn"|"BufferSizeInMBs"|"BufferIntervalInSeconds",
              ParameterValue = "string"
            )
          )
        )
      )
    ),
    CloudWatchLoggingOptions = list(
      Enabled = TRUE|FALSE,
      LogGroupName = "string",
      LogStreamName = "string"
    )
  )
)
}
}

\keyword{internal}
