% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_enable_enhanced_monitoring}
\alias{kinesis_enable_enhanced_monitoring}
\title{Enables enhanced Kinesis data stream monitoring for shard-level metrics}
\usage{
kinesis_enable_enhanced_monitoring(StreamName, ShardLevelMetrics)
}
\arguments{
\item{StreamName}{[required] The name of the stream for which to enable enhanced monitoring.}

\item{ShardLevelMetrics}{[required] List of shard-level metrics to enable.

The following are the valid shard-level metrics. The value \"\code{ALL}\"
enables every metric.
\itemize{
\item \code{IncomingBytes}
\item \code{IncomingRecords}
\item \code{OutgoingBytes}
\item \code{OutgoingRecords}
\item \code{WriteProvisionedThroughputExceeded}
\item \code{ReadProvisionedThroughputExceeded}
\item \code{IteratorAgeMilliseconds}
\item \code{ALL}
}

For more information, see \href{http://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html}{Monitoring the Amazon Kinesis Data Streams Service with Amazon CloudWatch}
in the \emph{Amazon Kinesis Data Streams Developer Guide}.}
}
\description{
Enables enhanced Kinesis data stream monitoring for shard-level metrics.
}
\section{Request syntax}{
\preformatted{svc$enable_enhanced_monitoring(
  StreamName = "string",
  ShardLevelMetrics = list(
    "IncomingBytes"|"IncomingRecords"|"OutgoingBytes"|"OutgoingRecords"|"WriteProvisionedThroughputExceeded"|"ReadProvisionedThroughputExceeded"|"IteratorAgeMilliseconds"|"ALL"
  )
)
}
}

\keyword{internal}
