% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_start_calculation_execution}
\alias{athena_start_calculation_execution}
\title{Submits calculations for execution within a session}
\usage{
athena_start_calculation_execution(
  SessionId,
  Description = NULL,
  CalculationConfiguration = NULL,
  CodeBlock = NULL,
  ClientRequestToken = NULL
)
}
\arguments{
\item{SessionId}{[required] The session ID.}

\item{Description}{A description of the calculation.}

\item{CalculationConfiguration}{Contains configuration information for the calculation.}

\item{CodeBlock}{A string that contains the code of the calculation.}

\item{ClientRequestToken}{A unique case-sensitive string used to ensure the request to create the
calculation is idempotent (executes only once). If another
\code{StartCalculationExecutionRequest} is received, the same response is
returned and another calculation is not created. If a parameter has
changed, an error is returned.

This token is listed as not required because Amazon Web Services SDKs
(for example the Amazon Web Services SDK for Java) auto-generate the
token for users. If you are not using the Amazon Web Services SDK or the
Amazon Web Services CLI, you must provide this token or the action will
fail.}
}
\description{
Submits calculations for execution within a session. You can supply the code to run as an inline code block within the request.

See \url{https://www.paws-r-sdk.com/docs/athena_start_calculation_execution/} for full documentation.
}
\keyword{internal}
