% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_update_query_suggestions_config}
\alias{kendra_update_query_suggestions_config}
\title{Updates the settings of query suggestions for an index}
\usage{
kendra_update_query_suggestions_config(
  IndexId,
  Mode = NULL,
  QueryLogLookBackWindowInDays = NULL,
  IncludeQueriesWithoutUserInformation = NULL,
  MinimumNumberOfQueryingUsers = NULL,
  MinimumQueryCount = NULL,
  AttributeSuggestionsConfig = NULL
)
}
\arguments{
\item{IndexId}{[required] The identifier of the index with query suggestions you want to update.}

\item{Mode}{Set the mode to \code{ENABLED} or \code{LEARN_ONLY}.

By default, Amazon Kendra enables query suggestions. \code{LEARN_ONLY} mode
allows you to turn off query suggestions. You can to update this at any
time.

In \code{LEARN_ONLY} mode, Amazon Kendra continues to learn from new queries
to keep suggestions up to date for when you are ready to switch to
ENABLED mode again.}

\item{QueryLogLookBackWindowInDays}{How recent your queries are in your query log time window.

The time window is the number of days from current day to past days.

By default, Amazon Kendra sets this to 180.}

\item{IncludeQueriesWithoutUserInformation}{\code{TRUE} to include queries without user information (i.e. all queries,
irrespective of the user), otherwise \code{FALSE} to only include queries
with user information.

If you pass user information to Amazon Kendra along with the queries,
you can set this flag to \code{FALSE} and instruct Amazon Kendra to only
consider queries with user information.

If you set to \code{FALSE}, Amazon Kendra only considers queries searched at
least \code{MinimumQueryCount} times across \code{MinimumNumberOfQueryingUsers}
unique users for suggestions.

If you set to \code{TRUE}, Amazon Kendra ignores all user information and
learns from all queries.}

\item{MinimumNumberOfQueryingUsers}{The minimum number of unique users who must search a query in order for
the query to be eligible to suggest to your users.

Increasing this number might decrease the number of suggestions.
However, this ensures a query is searched by many users and is truly
popular to suggest to users.

How you tune this setting depends on your specific needs.}

\item{MinimumQueryCount}{The the minimum number of times a query must be searched in order to be
eligible to suggest to your users.

Decreasing this number increases the number of suggestions. However,
this affects the quality of suggestions as it sets a low bar for a query
to be considered popular to suggest to users.

How you tune this setting depends on your specific needs.}

\item{AttributeSuggestionsConfig}{Configuration information for the document fields/attributes that you
want to base query suggestions on.}
}
\description{
Updates the settings of query suggestions for an index.

See \url{https://www.paws-r-sdk.com/docs/kendra_update_query_suggestions_config/} for full documentation.
}
\keyword{internal}
