% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_list_executors}
\alias{athena_list_executors}
\title{Lists, in descending order, the executors that joined a session}
\usage{
athena_list_executors(
  SessionId,
  ExecutorStateFilter = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{SessionId}{[required] The session ID.}

\item{ExecutorStateFilter}{A filter for a specific executor state. A description of each state
follows.

\code{CREATING} - The executor is being started, including acquiring
resources.

\code{CREATED} - The executor has been started.

\code{REGISTERED} - The executor has been registered.

\code{TERMINATING} - The executor is in the process of shutting down.

\code{TERMINATED} - The executor is no longer running.

\code{FAILED} - Due to a failure, the executor is no longer running.}

\item{MaxResults}{The maximum number of executors to return.}

\item{NextToken}{A token generated by the Athena service that specifies where to continue
pagination if a previous request was truncated. To obtain the next set
of pages, pass in the \code{NextToken} from the response object of the
previous page call.}
}
\description{
Lists, in descending order, the executors that joined a session. Newer executors are listed first; older executors are listed later. The result can be optionally filtered by state.

See \url{https://www.paws-r-sdk.com/docs/athena_list_executors/} for full documentation.
}
\keyword{internal}
