% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafkaconnect_operations.R
\name{kafkaconnect_create_connector}
\alias{kafkaconnect_create_connector}
\title{Creates a connector using the specified properties}
\usage{
kafkaconnect_create_connector(
  capacity,
  connectorConfiguration,
  connectorDescription = NULL,
  connectorName,
  kafkaCluster,
  kafkaClusterClientAuthentication,
  kafkaClusterEncryptionInTransit,
  kafkaConnectVersion,
  logDelivery = NULL,
  plugins,
  serviceExecutionRoleArn,
  workerConfiguration = NULL
)
}
\arguments{
\item{capacity}{[required] Information about the capacity allocated to the connector. Exactly one
of the two properties must be specified.}

\item{connectorConfiguration}{[required] A map of keys to values that represent the configuration for the
connector.}

\item{connectorDescription}{A summary description of the connector.}

\item{connectorName}{[required] The name of the connector.}

\item{kafkaCluster}{[required] Specifies which Apache Kafka cluster to connect to.}

\item{kafkaClusterClientAuthentication}{[required] Details of the client authentication used by the Apache Kafka cluster.}

\item{kafkaClusterEncryptionInTransit}{[required] Details of encryption in transit to the Apache Kafka cluster.}

\item{kafkaConnectVersion}{[required] The version of Kafka Connect. It has to be compatible with both the
Apache Kafka cluster's version and the plugins.}

\item{logDelivery}{Details about log delivery.}

\item{plugins}{[required] Specifies which plugins to use for the connector.}

\item{serviceExecutionRoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role used by the connector to
access the Amazon Web Services resources that it needs. The types of
resources depends on the logic of the connector. For example, a
connector that has Amazon S3 as a destination must have permissions that
allow it to write to the S3 destination bucket.}

\item{workerConfiguration}{Specifies which worker configuration to use with the connector.}
}
\description{
Creates a connector using the specified properties.

See \url{https://www.paws-r-sdk.com/docs/kafkaconnect_create_connector/} for full documentation.
}
\keyword{internal}
