# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include firehose_service.R
NULL

#' Creates a Firehose stream
#'
#' @description
#' Creates a Firehose stream.
#'
#' See [https://www.paws-r-sdk.com/docs/firehose_create_delivery_stream/](https://www.paws-r-sdk.com/docs/firehose_create_delivery_stream/) for full documentation.
#'
#' @param DeliveryStreamName &#91;required&#93; The name of the Firehose stream. This name must be unique per Amazon Web
#' Services account in the same Amazon Web Services Region. If the Firehose
#' streams are in different accounts or different Regions, you can have
#' multiple Firehose streams with the same name.
#' @param DeliveryStreamType The Firehose stream type. This parameter can be one of the following
#' values:
#' 
#' -   `DirectPut`: Provider applications access the Firehose stream
#'     directly.
#' 
#' -   `KinesisStreamAsSource`: The Firehose stream uses a Kinesis data
#'     stream as a source.
#' @param KinesisStreamSourceConfiguration When a Kinesis data stream is used as the source for the Firehose
#' stream, a KinesisStreamSourceConfiguration containing the Kinesis data
#' stream Amazon Resource Name (ARN) and the role ARN for the source
#' stream.
#' @param DeliveryStreamEncryptionConfigurationInput Used to specify the type and Amazon Resource Name (ARN) of the KMS key
#' needed for Server-Side Encryption (SSE).
#' @param S3DestinationConfiguration \[Deprecated\] The destination in Amazon S3. You can specify only one
#' destination.
#' @param ExtendedS3DestinationConfiguration The destination in Amazon S3. You can specify only one destination.
#' @param RedshiftDestinationConfiguration The destination in Amazon Redshift. You can specify only one
#' destination.
#' @param ElasticsearchDestinationConfiguration The destination in Amazon ES. You can specify only one destination.
#' @param AmazonopensearchserviceDestinationConfiguration The destination in Amazon OpenSearch Service. You can specify only one
#' destination.
#' @param SplunkDestinationConfiguration The destination in Splunk. You can specify only one destination.
#' @param HttpEndpointDestinationConfiguration Enables configuring Kinesis Firehose to deliver data to any HTTP
#' endpoint destination. You can specify only one destination.
#' @param Tags A set of tags to assign to the Firehose stream. A tag is a key-value
#' pair that you can define and assign to Amazon Web Services resources.
#' Tags are metadata. For example, you can add friendly names and
#' descriptions or other types of information that can help you distinguish
#' the Firehose stream. For more information about tags, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
#' in the Amazon Web Services Billing and Cost Management User Guide.
#' 
#' You can specify up to 50 tags when creating a Firehose stream.
#' 
#' If you specify tags in the
#' [`create_delivery_stream`][firehose_create_delivery_stream] action,
#' Amazon Data Firehose performs an additional authorization on the
#' `firehose:TagDeliveryStream` action to verify if users have permissions
#' to create tags. If you do not provide this permission, requests to
#' create new Firehose Firehose streams with IAM resource tags will fail
#' with an `AccessDeniedException` such as following.
#' 
#' **AccessDeniedException**
#' 
#' User: arn:aws:sts::x:assumed-role/x/x is not authorized to perform:
#' firehose:TagDeliveryStream on resource:
#' arn:aws:firehose:us-east-1:x:deliverystream/x with an explicit deny in
#' an identity-based policy.
#' 
#' For an example IAM policy, see [Tag
#' example.](https://docs.aws.amazon.com/firehose/latest/APIReference/API_CreateDeliveryStream.html#API_CreateDeliveryStream_Examples)
#' @param AmazonOpenSearchServerlessDestinationConfiguration The destination in the Serverless offering for Amazon OpenSearch
#' Service. You can specify only one destination.
#' @param MSKSourceConfiguration 
#' @param SnowflakeDestinationConfiguration Configure Snowflake destination
#' @param IcebergDestinationConfiguration Configure Apache Iceberg Tables destination.
#' @param DatabaseSourceConfiguration Amazon Data Firehose is in preview release and is subject to change.
#'
#' @keywords internal
#'
#' @rdname firehose_create_delivery_stream
firehose_create_delivery_stream <- function(DeliveryStreamName, DeliveryStreamType = NULL, KinesisStreamSourceConfiguration = NULL, DeliveryStreamEncryptionConfigurationInput = NULL, S3DestinationConfiguration = NULL, ExtendedS3DestinationConfiguration = NULL, RedshiftDestinationConfiguration = NULL, ElasticsearchDestinationConfiguration = NULL, AmazonopensearchserviceDestinationConfiguration = NULL, SplunkDestinationConfiguration = NULL, HttpEndpointDestinationConfiguration = NULL, Tags = NULL, AmazonOpenSearchServerlessDestinationConfiguration = NULL, MSKSourceConfiguration = NULL, SnowflakeDestinationConfiguration = NULL, IcebergDestinationConfiguration = NULL, DatabaseSourceConfiguration = NULL) {
  op <- new_operation(
    name = "CreateDeliveryStream",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .firehose$create_delivery_stream_input(DeliveryStreamName = DeliveryStreamName, DeliveryStreamType = DeliveryStreamType, KinesisStreamSourceConfiguration = KinesisStreamSourceConfiguration, DeliveryStreamEncryptionConfigurationInput = DeliveryStreamEncryptionConfigurationInput, S3DestinationConfiguration = S3DestinationConfiguration, ExtendedS3DestinationConfiguration = ExtendedS3DestinationConfiguration, RedshiftDestinationConfiguration = RedshiftDestinationConfiguration, ElasticsearchDestinationConfiguration = ElasticsearchDestinationConfiguration, AmazonopensearchserviceDestinationConfiguration = AmazonopensearchserviceDestinationConfiguration, SplunkDestinationConfiguration = SplunkDestinationConfiguration, HttpEndpointDestinationConfiguration = HttpEndpointDestinationConfiguration, Tags = Tags, AmazonOpenSearchServerlessDestinationConfiguration = AmazonOpenSearchServerlessDestinationConfiguration, MSKSourceConfiguration = MSKSourceConfiguration, SnowflakeDestinationConfiguration = SnowflakeDestinationConfiguration, IcebergDestinationConfiguration = IcebergDestinationConfiguration, DatabaseSourceConfiguration = DatabaseSourceConfiguration)
  output <- .firehose$create_delivery_stream_output()
  config <- get_config()
  svc <- .firehose$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.firehose$operations$create_delivery_stream <- firehose_create_delivery_stream

#' Deletes a Firehose stream and its data
#'
#' @description
#' Deletes a Firehose stream and its data.
#'
#' See [https://www.paws-r-sdk.com/docs/firehose_delete_delivery_stream/](https://www.paws-r-sdk.com/docs/firehose_delete_delivery_stream/) for full documentation.
#'
#' @param DeliveryStreamName &#91;required&#93; The name of the Firehose stream.
#' @param AllowForceDelete Set this to true if you want to delete the Firehose stream even if
#' Firehose is unable to retire the grant for the CMK. Firehose might be
#' unable to retire the grant due to a customer error, such as when the CMK
#' or the grant are in an invalid state. If you force deletion, you can
#' then use the
#' [RevokeGrant](https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html)
#' operation to revoke the grant you gave to Firehose. If a failure to
#' retire the grant happens due to an Amazon Web Services KMS issue,
#' Firehose keeps retrying the delete operation.
#' 
#' The default value is false.
#'
#' @keywords internal
#'
#' @rdname firehose_delete_delivery_stream
firehose_delete_delivery_stream <- function(DeliveryStreamName, AllowForceDelete = NULL) {
  op <- new_operation(
    name = "DeleteDeliveryStream",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .firehose$delete_delivery_stream_input(DeliveryStreamName = DeliveryStreamName, AllowForceDelete = AllowForceDelete)
  output <- .firehose$delete_delivery_stream_output()
  config <- get_config()
  svc <- .firehose$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.firehose$operations$delete_delivery_stream <- firehose_delete_delivery_stream

#' Describes the specified Firehose stream and its status
#'
#' @description
#' Describes the specified Firehose stream and its status. For example, after your Firehose stream is created, call [`describe_delivery_stream`][firehose_describe_delivery_stream] to see whether the Firehose stream is `ACTIVE` and therefore ready for data to be sent to it.
#'
#' See [https://www.paws-r-sdk.com/docs/firehose_describe_delivery_stream/](https://www.paws-r-sdk.com/docs/firehose_describe_delivery_stream/) for full documentation.
#'
#' @param DeliveryStreamName &#91;required&#93; The name of the Firehose stream.
#' @param Limit The limit on the number of destinations to return. You can have one
#' destination per Firehose stream.
#' @param ExclusiveStartDestinationId The ID of the destination to start returning the destination
#' information. Firehose supports one destination per Firehose stream.
#'
#' @keywords internal
#'
#' @rdname firehose_describe_delivery_stream
firehose_describe_delivery_stream <- function(DeliveryStreamName, Limit = NULL, ExclusiveStartDestinationId = NULL) {
  op <- new_operation(
    name = "DescribeDeliveryStream",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .firehose$describe_delivery_stream_input(DeliveryStreamName = DeliveryStreamName, Limit = Limit, ExclusiveStartDestinationId = ExclusiveStartDestinationId)
  output <- .firehose$describe_delivery_stream_output()
  config <- get_config()
  svc <- .firehose$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.firehose$operations$describe_delivery_stream <- firehose_describe_delivery_stream

#' Lists your Firehose streams in alphabetical order of their names
#'
#' @description
#' Lists your Firehose streams in alphabetical order of their names.
#'
#' See [https://www.paws-r-sdk.com/docs/firehose_list_delivery_streams/](https://www.paws-r-sdk.com/docs/firehose_list_delivery_streams/) for full documentation.
#'
#' @param Limit The maximum number of Firehose streams to list. The default value is 10.
#' @param DeliveryStreamType The Firehose stream type. This can be one of the following values:
#' 
#' -   `DirectPut`: Provider applications access the Firehose stream
#'     directly.
#' 
#' -   `KinesisStreamAsSource`: The Firehose stream uses a Kinesis data
#'     stream as a source.
#' 
#' This parameter is optional. If this parameter is omitted, Firehose
#' streams of all types are returned.
#' @param ExclusiveStartDeliveryStreamName The list of Firehose streams returned by this call to
#' [`list_delivery_streams`][firehose_list_delivery_streams] will start
#' with the Firehose stream whose name comes alphabetically immediately
#' after the name you specify in `ExclusiveStartDeliveryStreamName`.
#'
#' @keywords internal
#'
#' @rdname firehose_list_delivery_streams
firehose_list_delivery_streams <- function(Limit = NULL, DeliveryStreamType = NULL, ExclusiveStartDeliveryStreamName = NULL) {
  op <- new_operation(
    name = "ListDeliveryStreams",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .firehose$list_delivery_streams_input(Limit = Limit, DeliveryStreamType = DeliveryStreamType, ExclusiveStartDeliveryStreamName = ExclusiveStartDeliveryStreamName)
  output <- .firehose$list_delivery_streams_output()
  config <- get_config()
  svc <- .firehose$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.firehose$operations$list_delivery_streams <- firehose_list_delivery_streams

#' Lists the tags for the specified Firehose stream
#'
#' @description
#' Lists the tags for the specified Firehose stream. This operation has a limit of five transactions per second per account.
#'
#' See [https://www.paws-r-sdk.com/docs/firehose_list_tags_for_delivery_stream/](https://www.paws-r-sdk.com/docs/firehose_list_tags_for_delivery_stream/) for full documentation.
#'
#' @param DeliveryStreamName &#91;required&#93; The name of the Firehose stream whose tags you want to list.
#' @param ExclusiveStartTagKey The key to use as the starting point for the list of tags. If you set
#' this parameter,
#' [`list_tags_for_delivery_stream`][firehose_list_tags_for_delivery_stream]
#' gets all tags that occur after `ExclusiveStartTagKey`.
#' @param Limit The number of tags to return. If this number is less than the total
#' number of tags associated with the Firehose stream, `HasMoreTags` is set
#' to `true` in the response. To list additional tags, set
#' `ExclusiveStartTagKey` to the last key in the response.
#'
#' @keywords internal
#'
#' @rdname firehose_list_tags_for_delivery_stream
firehose_list_tags_for_delivery_stream <- function(DeliveryStreamName, ExclusiveStartTagKey = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTagsForDeliveryStream",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .firehose$list_tags_for_delivery_stream_input(DeliveryStreamName = DeliveryStreamName, ExclusiveStartTagKey = ExclusiveStartTagKey, Limit = Limit)
  output <- .firehose$list_tags_for_delivery_stream_output()
  config <- get_config()
  svc <- .firehose$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.firehose$operations$list_tags_for_delivery_stream <- firehose_list_tags_for_delivery_stream

#' Writes a single data record into an Firehose stream
#'
#' @description
#' Writes a single data record into an Firehose stream. To write multiple data records into a Firehose stream, use [`put_record_batch`][firehose_put_record_batch]. Applications using these operations are referred to as producers.
#'
#' See [https://www.paws-r-sdk.com/docs/firehose_put_record/](https://www.paws-r-sdk.com/docs/firehose_put_record/) for full documentation.
#'
#' @param DeliveryStreamName &#91;required&#93; The name of the Firehose stream.
#' @param Record &#91;required&#93; The record.
#'
#' @keywords internal
#'
#' @rdname firehose_put_record
firehose_put_record <- function(DeliveryStreamName, Record) {
  op <- new_operation(
    name = "PutRecord",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .firehose$put_record_input(DeliveryStreamName = DeliveryStreamName, Record = Record)
  output <- .firehose$put_record_output()
  config <- get_config()
  svc <- .firehose$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.firehose$operations$put_record <- firehose_put_record

#' Writes multiple data records into a Firehose stream in a single call,
#' which can achieve higher throughput per producer than when writing
#' single records
#'
#' @description
#' Writes multiple data records into a Firehose stream in a single call, which can achieve higher throughput per producer than when writing single records. To write single data records into a Firehose stream, use [`put_record`][firehose_put_record]. Applications using these operations are referred to as producers.
#'
#' See [https://www.paws-r-sdk.com/docs/firehose_put_record_batch/](https://www.paws-r-sdk.com/docs/firehose_put_record_batch/) for full documentation.
#'
#' @param DeliveryStreamName &#91;required&#93; The name of the Firehose stream.
#' @param Records &#91;required&#93; One or more records.
#'
#' @keywords internal
#'
#' @rdname firehose_put_record_batch
firehose_put_record_batch <- function(DeliveryStreamName, Records) {
  op <- new_operation(
    name = "PutRecordBatch",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .firehose$put_record_batch_input(DeliveryStreamName = DeliveryStreamName, Records = Records)
  output <- .firehose$put_record_batch_output()
  config <- get_config()
  svc <- .firehose$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.firehose$operations$put_record_batch <- firehose_put_record_batch

#' Enables server-side encryption (SSE) for the Firehose stream
#'
#' @description
#' Enables server-side encryption (SSE) for the Firehose stream.
#'
#' See [https://www.paws-r-sdk.com/docs/firehose_start_delivery_stream_encryption/](https://www.paws-r-sdk.com/docs/firehose_start_delivery_stream_encryption/) for full documentation.
#'
#' @param DeliveryStreamName &#91;required&#93; The name of the Firehose stream for which you want to enable server-side
#' encryption (SSE).
#' @param DeliveryStreamEncryptionConfigurationInput Used to specify the type and Amazon Resource Name (ARN) of the KMS key
#' needed for Server-Side Encryption (SSE).
#'
#' @keywords internal
#'
#' @rdname firehose_start_delivery_stream_encryption
firehose_start_delivery_stream_encryption <- function(DeliveryStreamName, DeliveryStreamEncryptionConfigurationInput = NULL) {
  op <- new_operation(
    name = "StartDeliveryStreamEncryption",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .firehose$start_delivery_stream_encryption_input(DeliveryStreamName = DeliveryStreamName, DeliveryStreamEncryptionConfigurationInput = DeliveryStreamEncryptionConfigurationInput)
  output <- .firehose$start_delivery_stream_encryption_output()
  config <- get_config()
  svc <- .firehose$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.firehose$operations$start_delivery_stream_encryption <- firehose_start_delivery_stream_encryption

#' Disables server-side encryption (SSE) for the Firehose stream
#'
#' @description
#' Disables server-side encryption (SSE) for the Firehose stream.
#'
#' See [https://www.paws-r-sdk.com/docs/firehose_stop_delivery_stream_encryption/](https://www.paws-r-sdk.com/docs/firehose_stop_delivery_stream_encryption/) for full documentation.
#'
#' @param DeliveryStreamName &#91;required&#93; The name of the Firehose stream for which you want to disable
#' server-side encryption (SSE).
#'
#' @keywords internal
#'
#' @rdname firehose_stop_delivery_stream_encryption
firehose_stop_delivery_stream_encryption <- function(DeliveryStreamName) {
  op <- new_operation(
    name = "StopDeliveryStreamEncryption",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .firehose$stop_delivery_stream_encryption_input(DeliveryStreamName = DeliveryStreamName)
  output <- .firehose$stop_delivery_stream_encryption_output()
  config <- get_config()
  svc <- .firehose$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.firehose$operations$stop_delivery_stream_encryption <- firehose_stop_delivery_stream_encryption

#' Adds or updates tags for the specified Firehose stream
#'
#' @description
#' Adds or updates tags for the specified Firehose stream. A tag is a key-value pair that you can define and assign to Amazon Web Services resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the Firehose stream. For more information about tags, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Amazon Web Services Billing and Cost Management User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/firehose_tag_delivery_stream/](https://www.paws-r-sdk.com/docs/firehose_tag_delivery_stream/) for full documentation.
#'
#' @param DeliveryStreamName &#91;required&#93; The name of the Firehose stream to which you want to add the tags.
#' @param Tags &#91;required&#93; A set of key-value pairs to use to create the tags.
#'
#' @keywords internal
#'
#' @rdname firehose_tag_delivery_stream
firehose_tag_delivery_stream <- function(DeliveryStreamName, Tags) {
  op <- new_operation(
    name = "TagDeliveryStream",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .firehose$tag_delivery_stream_input(DeliveryStreamName = DeliveryStreamName, Tags = Tags)
  output <- .firehose$tag_delivery_stream_output()
  config <- get_config()
  svc <- .firehose$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.firehose$operations$tag_delivery_stream <- firehose_tag_delivery_stream

#' Removes tags from the specified Firehose stream
#'
#' @description
#' Removes tags from the specified Firehose stream. Removed tags are deleted, and you can't recover them after this operation successfully completes.
#'
#' See [https://www.paws-r-sdk.com/docs/firehose_untag_delivery_stream/](https://www.paws-r-sdk.com/docs/firehose_untag_delivery_stream/) for full documentation.
#'
#' @param DeliveryStreamName &#91;required&#93; The name of the Firehose stream.
#' @param TagKeys &#91;required&#93; A list of tag keys. Each corresponding tag is removed from the delivery
#' stream.
#'
#' @keywords internal
#'
#' @rdname firehose_untag_delivery_stream
firehose_untag_delivery_stream <- function(DeliveryStreamName, TagKeys) {
  op <- new_operation(
    name = "UntagDeliveryStream",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .firehose$untag_delivery_stream_input(DeliveryStreamName = DeliveryStreamName, TagKeys = TagKeys)
  output <- .firehose$untag_delivery_stream_output()
  config <- get_config()
  svc <- .firehose$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.firehose$operations$untag_delivery_stream <- firehose_untag_delivery_stream

#' Updates the specified destination of the specified Firehose stream
#'
#' @description
#' Updates the specified destination of the specified Firehose stream.
#'
#' See [https://www.paws-r-sdk.com/docs/firehose_update_destination/](https://www.paws-r-sdk.com/docs/firehose_update_destination/) for full documentation.
#'
#' @param DeliveryStreamName &#91;required&#93; The name of the Firehose stream.
#' @param CurrentDeliveryStreamVersionId &#91;required&#93; Obtain this value from the `VersionId` result of
#' DeliveryStreamDescription. This value is required, and helps the service
#' perform conditional operations. For example, if there is an interleaving
#' update and this value is null, then the update destination fails. After
#' the update is successful, the `VersionId` value is updated. The service
#' then performs a merge of the old configuration with the new
#' configuration.
#' @param DestinationId &#91;required&#93; The ID of the destination.
#' @param S3DestinationUpdate \[Deprecated\] Describes an update for a destination in Amazon S3.
#' @param ExtendedS3DestinationUpdate Describes an update for a destination in Amazon S3.
#' @param RedshiftDestinationUpdate Describes an update for a destination in Amazon Redshift.
#' @param ElasticsearchDestinationUpdate Describes an update for a destination in Amazon ES.
#' @param AmazonopensearchserviceDestinationUpdate Describes an update for a destination in Amazon OpenSearch Service.
#' @param SplunkDestinationUpdate Describes an update for a destination in Splunk.
#' @param HttpEndpointDestinationUpdate Describes an update to the specified HTTP endpoint destination.
#' @param AmazonOpenSearchServerlessDestinationUpdate Describes an update for a destination in the Serverless offering for
#' Amazon OpenSearch Service.
#' @param SnowflakeDestinationUpdate Update to the Snowflake destination configuration settings.
#' @param IcebergDestinationUpdate Describes an update for a destination in Apache Iceberg Tables.
#'
#' @keywords internal
#'
#' @rdname firehose_update_destination
firehose_update_destination <- function(DeliveryStreamName, CurrentDeliveryStreamVersionId, DestinationId, S3DestinationUpdate = NULL, ExtendedS3DestinationUpdate = NULL, RedshiftDestinationUpdate = NULL, ElasticsearchDestinationUpdate = NULL, AmazonopensearchserviceDestinationUpdate = NULL, SplunkDestinationUpdate = NULL, HttpEndpointDestinationUpdate = NULL, AmazonOpenSearchServerlessDestinationUpdate = NULL, SnowflakeDestinationUpdate = NULL, IcebergDestinationUpdate = NULL) {
  op <- new_operation(
    name = "UpdateDestination",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .firehose$update_destination_input(DeliveryStreamName = DeliveryStreamName, CurrentDeliveryStreamVersionId = CurrentDeliveryStreamVersionId, DestinationId = DestinationId, S3DestinationUpdate = S3DestinationUpdate, ExtendedS3DestinationUpdate = ExtendedS3DestinationUpdate, RedshiftDestinationUpdate = RedshiftDestinationUpdate, ElasticsearchDestinationUpdate = ElasticsearchDestinationUpdate, AmazonopensearchserviceDestinationUpdate = AmazonopensearchserviceDestinationUpdate, SplunkDestinationUpdate = SplunkDestinationUpdate, HttpEndpointDestinationUpdate = HttpEndpointDestinationUpdate, AmazonOpenSearchServerlessDestinationUpdate = AmazonOpenSearchServerlessDestinationUpdate, SnowflakeDestinationUpdate = SnowflakeDestinationUpdate, IcebergDestinationUpdate = IcebergDestinationUpdate)
  output <- .firehose$update_destination_output()
  config <- get_config()
  svc <- .firehose$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.firehose$operations$update_destination <- firehose_update_destination
