% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_list_notifications}
\alias{datazone_list_notifications}
\title{Lists all Amazon DataZone notifications}
\usage{
datazone_list_notifications(
  afterTimestamp = NULL,
  beforeTimestamp = NULL,
  domainIdentifier,
  maxResults = NULL,
  nextToken = NULL,
  subjects = NULL,
  taskStatus = NULL,
  type
)
}
\arguments{
\item{afterTimestamp}{The time after which you want to list notifications.}

\item{beforeTimestamp}{The time before which you want to list notifications.}

\item{domainIdentifier}{[required] The identifier of the Amazon DataZone domain.}

\item{maxResults}{The maximum number of notifications to return in a single call to
\code{\link[=datazone_list_notifications]{list_notifications}}. When the number of
notifications to be listed is greater than the value of \code{MaxResults},
the response contains a \code{NextToken} value that you can use in a
subsequent call to \code{\link[=datazone_list_notifications]{list_notifications}}
to list the next set of notifications.}

\item{nextToken}{When the number of notifications is greater than the default value for
the \code{MaxResults} parameter, or if you explicitly specify a value for
\code{MaxResults} that is less than the number of notifications, the response
includes a pagination token named \code{NextToken}. You can specify this
\code{NextToken} value in a subsequent call to
\code{\link[=datazone_list_notifications]{list_notifications}} to list the next set
of notifications.}

\item{subjects}{The subjects of notifications.}

\item{taskStatus}{The task status of notifications.}

\item{type}{[required] The type of notifications.}
}
\description{
Lists all Amazon DataZone notifications.

See \url{https://www.paws-r-sdk.com/docs/datazone_list_notifications/} for full documentation.
}
\keyword{internal}
