% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_search_tables}
\alias{glue_search_tables}
\title{Searches a set of tables based on properties in the table metadata as
well as on the parent database}
\usage{
glue_search_tables(
  CatalogId = NULL,
  NextToken = NULL,
  Filters = NULL,
  SearchText = NULL,
  SortCriteria = NULL,
  MaxResults = NULL,
  ResourceShareType = NULL,
  IncludeStatusDetails = NULL
)
}
\arguments{
\item{CatalogId}{A unique identifier, consisting of \code{account_id}.}

\item{NextToken}{A continuation token, included if this is a continuation call.}

\item{Filters}{A list of key-value pairs, and a comparator used to filter the search
results. Returns all entities matching the predicate.

The \code{Comparator} member of the \code{PropertyPredicate} struct is used only
for time fields, and can be omitted for other field types. Also, when
comparing string values, such as when \code{Key=Name}, a fuzzy match
algorithm is used. The \code{Key} field (for example, the value of the \code{Name}
field) is split on certain punctuation characters, for example, -, :,
#, etc. into tokens. Then each token is exact-match compared with the
\code{Value} member of \code{PropertyPredicate}. For example, if \code{Key=Name} and
\code{Value=link}, tables named \code{customer-link} and \code{xx-link-yy} are
returned, but \code{xxlinkyy} is not returned.}

\item{SearchText}{A string used for a text search.

Specifying a value in quotes filters based on an exact match to the
value.}

\item{SortCriteria}{A list of criteria for sorting the results by a field name, in an
ascending or descending order.}

\item{MaxResults}{The maximum number of tables to return in a single response.}

\item{ResourceShareType}{Allows you to specify that you want to search the tables shared with
your account. The allowable values are \code{FOREIGN} or \code{ALL}.
\itemize{
\item If set to \code{FOREIGN}, will search the tables shared with your
account.
\item If set to \code{ALL}, will search the tables shared with your account, as
well as the tables in yor local account.
}}

\item{IncludeStatusDetails}{Specifies whether to include status details related to a request to
create or update an Glue Data Catalog view.}
}
\description{
Searches a set of tables based on properties in the table metadata as well as on the parent database. You can search against text or filter conditions.

See \url{https://www.paws-r-sdk.com/docs/glue_search_tables/} for full documentation.
}
\keyword{internal}
