% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opensearchservice_operations.R
\name{opensearchservice_add_direct_query_data_source}
\alias{opensearchservice_add_direct_query_data_source}
\title{Adds a new data source in Amazon OpenSearch Service so that you can
perform direct queries on external data}
\usage{
opensearchservice_add_direct_query_data_source(
  DataSourceName,
  DataSourceType,
  Description = NULL,
  OpenSearchArns,
  TagList = NULL
)
}
\arguments{
\item{DataSourceName}{[required] A unique, user-defined label to identify the data source within your
OpenSearch Service environment.}

\item{DataSourceType}{[required] The supported Amazon Web Services service that you want to use as the
source for direct queries in OpenSearch Service.}

\item{Description}{An optional text field for providing additional context and details
about the data source.}

\item{OpenSearchArns}{[required] A list of Amazon Resource Names (ARNs) for the OpenSearch collections
that are associated with the direct query data source.}

\item{TagList}{}
}
\description{
Adds a new data source in Amazon OpenSearch Service so that you can perform direct queries on external data.

See \url{https://www.paws-r-sdk.com/docs/opensearchservice_add_direct_query_data_source/} for full documentation.
}
\keyword{internal}
