% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opensearchservice_operations.R
\name{opensearchservice_create_package}
\alias{opensearchservice_create_package}
\title{Creates a package for use with Amazon OpenSearch Service domains}
\usage{
opensearchservice_create_package(
  PackageName,
  PackageType,
  PackageDescription = NULL,
  PackageSource,
  PackageConfiguration = NULL,
  EngineVersion = NULL,
  PackageVendingOptions = NULL,
  PackageEncryptionOptions = NULL
)
}
\arguments{
\item{PackageName}{[required] Unique name for the package.}

\item{PackageType}{[required] The type of package.}

\item{PackageDescription}{Description of the package.}

\item{PackageSource}{[required] The Amazon S3 location from which to import the package.}

\item{PackageConfiguration}{The configuration parameters for the package being created.}

\item{EngineVersion}{The version of the Amazon OpenSearch Service engine for which is
compatible with the package. This can only be specified for package type
\code{ZIP-PLUGIN}}

\item{PackageVendingOptions}{The vending options for the package being created. They determine if the
package can be vended to other users.}

\item{PackageEncryptionOptions}{The encryption parameters for the package being created.}
}
\description{
Creates a package for use with Amazon OpenSearch Service domains. For more information, see \href{https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html}{Custom packages for Amazon OpenSearch Service}.

See \url{https://www.paws-r-sdk.com/docs/opensearchservice_create_package/} for full documentation.
}
\keyword{internal}
