# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include eventbridge_service.R
NULL

#' Activates a partner event source that has been deactivated
#'
#' @description
#' Activates a partner event source that has been deactivated. Once
#' activated, your matching event bus will start receiving events from the
#' event source.
#'
#' @usage
#' eventbridge_activate_event_source(Name)
#'
#' @param Name &#91;required&#93; The name of the partner event source to activate.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$activate_event_source(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_activate_event_source
eventbridge_activate_event_source <- function(Name) {
  op <- new_operation(
    name = "ActivateEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$activate_event_source_input(Name = Name)
  output <- .eventbridge$activate_event_source_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$activate_event_source <- eventbridge_activate_event_source

#' Cancels the specified replay
#'
#' @description
#' Cancels the specified replay.
#'
#' @usage
#' eventbridge_cancel_replay(ReplayName)
#'
#' @param ReplayName &#91;required&#93; The name of the replay to cancel.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ReplayArn = "string",
#'   State = "STARTING"|"RUNNING"|"CANCELLING"|"COMPLETED"|"CANCELLED"|"FAILED",
#'   StateReason = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$cancel_replay(
#'   ReplayName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_cancel_replay
eventbridge_cancel_replay <- function(ReplayName) {
  op <- new_operation(
    name = "CancelReplay",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$cancel_replay_input(ReplayName = ReplayName)
  output <- .eventbridge$cancel_replay_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$cancel_replay <- eventbridge_cancel_replay

#' Creates an archive of events with the specified settings
#'
#' @description
#' Creates an archive of events with the specified settings. When you
#' create an archive, incoming events might not immediately start being
#' sent to the archive. Allow a short period of time for changes to take
#' effect. If you do not specify a pattern to filter events sent to the
#' archive, all events are sent to the archive except replayed events.
#' Replayed events are not sent to an archive.
#'
#' @usage
#' eventbridge_create_archive(ArchiveName, EventSourceArn, Description,
#'   EventPattern, RetentionDays)
#'
#' @param ArchiveName &#91;required&#93; The name for the archive to create.
#' @param EventSourceArn &#91;required&#93; The ARN of the event source associated with the archive.
#' @param Description A description for the archive.
#' @param EventPattern An event pattern to use to filter events sent to the archive.
#' @param RetentionDays The number of days to retain events for. Default value is 0. If set to
#' 0, events are retained indefinitely
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ArchiveArn = "string",
#'   State = "ENABLED"|"DISABLED"|"CREATING"|"UPDATING"|"CREATE_FAILED"|"UPDATE_FAILED",
#'   StateReason = "string",
#'   CreationTime = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_archive(
#'   ArchiveName = "string",
#'   EventSourceArn = "string",
#'   Description = "string",
#'   EventPattern = "string",
#'   RetentionDays = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_create_archive
eventbridge_create_archive <- function(ArchiveName, EventSourceArn, Description = NULL, EventPattern = NULL, RetentionDays = NULL) {
  op <- new_operation(
    name = "CreateArchive",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$create_archive_input(ArchiveName = ArchiveName, EventSourceArn = EventSourceArn, Description = Description, EventPattern = EventPattern, RetentionDays = RetentionDays)
  output <- .eventbridge$create_archive_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$create_archive <- eventbridge_create_archive

#' Creates a new event bus within your account
#'
#' @description
#' Creates a new event bus within your account. This can be a custom event
#' bus which you can use to receive events from your custom applications
#' and services, or it can be a partner event bus which can be matched to a
#' partner event source.
#'
#' @usage
#' eventbridge_create_event_bus(Name, EventSourceName, Tags)
#'
#' @param Name &#91;required&#93; The name of the new event bus.
#' 
#' Event bus names cannot contain the / character. You can't use the name
#' `default` for a custom event bus, as this name is already used for your
#' account's default event bus.
#' 
#' If this is a partner event bus, the name must exactly match the name of
#' the partner event source that this event bus is matched to.
#' @param EventSourceName If you are creating a partner event bus, this specifies the partner
#' event source that the new event bus will be matched with.
#' @param Tags Tags to associate with the event bus.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   EventBusArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_event_bus(
#'   Name = "string",
#'   EventSourceName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_create_event_bus
eventbridge_create_event_bus <- function(Name, EventSourceName = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEventBus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$create_event_bus_input(Name = Name, EventSourceName = EventSourceName, Tags = Tags)
  output <- .eventbridge$create_event_bus_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$create_event_bus <- eventbridge_create_event_bus

#' Called by an SaaS partner to create a partner event source
#'
#' @description
#' Called by an SaaS partner to create a partner event source. This
#' operation is not used by AWS customers.
#' 
#' Each partner event source can be used by one AWS account to create a
#' matching partner event bus in that AWS account. A SaaS partner must
#' create one partner event source for each AWS account that wants to
#' receive those event types.
#' 
#' A partner event source creates events based on resources within the SaaS
#' partner's service or application.
#' 
#' An AWS account that creates a partner event bus that matches the partner
#' event source can use that event bus to receive events from the partner,
#' and then process them using AWS Events rules and targets.
#' 
#' Partner event source names follow this format:
#' 
#' ` partner_name/event_namespace/event_name `
#' 
#' *partner_name* is determined during partner registration and identifies
#' the partner to AWS customers. *event_namespace* is determined by the
#' partner and is a way for the partner to categorize their events.
#' *event_name* is determined by the partner, and should uniquely identify
#' an event-generating resource within the partner system. The combination
#' of *event_namespace* and *event_name* should help AWS customers decide
#' whether to create an event bus to receive these events.
#'
#' @usage
#' eventbridge_create_partner_event_source(Name, Account)
#'
#' @param Name &#91;required&#93; The name of the partner event source. This name must be unique and must
#' be in the format ` partner_name/event_namespace/event_name `. The AWS
#' account that wants to use this partner event source must create a
#' partner event bus with a name that matches the name of the partner event
#' source.
#' @param Account &#91;required&#93; The AWS account ID that is permitted to create a matching partner event
#' bus for this partner event source.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   EventSourceArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_partner_event_source(
#'   Name = "string",
#'   Account = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_create_partner_event_source
eventbridge_create_partner_event_source <- function(Name, Account) {
  op <- new_operation(
    name = "CreatePartnerEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$create_partner_event_source_input(Name = Name, Account = Account)
  output <- .eventbridge$create_partner_event_source_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$create_partner_event_source <- eventbridge_create_partner_event_source

#' You can use this operation to temporarily stop receiving events from the
#' specified partner event source
#'
#' @description
#' You can use this operation to temporarily stop receiving events from the
#' specified partner event source. The matching event bus is not deleted.
#' 
#' When you deactivate a partner event source, the source goes into PENDING
#' state. If it remains in PENDING state for more than two weeks, it is
#' deleted.
#' 
#' To activate a deactivated partner event source, use
#' [`activate_event_source`][eventbridge_activate_event_source].
#'
#' @usage
#' eventbridge_deactivate_event_source(Name)
#'
#' @param Name &#91;required&#93; The name of the partner event source to deactivate.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$deactivate_event_source(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_deactivate_event_source
eventbridge_deactivate_event_source <- function(Name) {
  op <- new_operation(
    name = "DeactivateEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$deactivate_event_source_input(Name = Name)
  output <- .eventbridge$deactivate_event_source_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$deactivate_event_source <- eventbridge_deactivate_event_source

#' Deletes the specified archive
#'
#' @description
#' Deletes the specified archive.
#'
#' @usage
#' eventbridge_delete_archive(ArchiveName)
#'
#' @param ArchiveName &#91;required&#93; The name of the archive to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_archive(
#'   ArchiveName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_delete_archive
eventbridge_delete_archive <- function(ArchiveName) {
  op <- new_operation(
    name = "DeleteArchive",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$delete_archive_input(ArchiveName = ArchiveName)
  output <- .eventbridge$delete_archive_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$delete_archive <- eventbridge_delete_archive

#' Deletes the specified custom event bus or partner event bus
#'
#' @description
#' Deletes the specified custom event bus or partner event bus. All rules
#' associated with this event bus need to be deleted. You can't delete your
#' account's default event bus.
#'
#' @usage
#' eventbridge_delete_event_bus(Name)
#'
#' @param Name &#91;required&#93; The name of the event bus to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_event_bus(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_delete_event_bus
eventbridge_delete_event_bus <- function(Name) {
  op <- new_operation(
    name = "DeleteEventBus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$delete_event_bus_input(Name = Name)
  output <- .eventbridge$delete_event_bus_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$delete_event_bus <- eventbridge_delete_event_bus

#' This operation is used by SaaS partners to delete a partner event source
#'
#' @description
#' This operation is used by SaaS partners to delete a partner event
#' source. This operation is not used by AWS customers.
#' 
#' When you delete an event source, the status of the corresponding partner
#' event bus in the AWS customer account becomes DELETED.
#'
#' @usage
#' eventbridge_delete_partner_event_source(Name, Account)
#'
#' @param Name &#91;required&#93; The name of the event source to delete.
#' @param Account &#91;required&#93; The AWS account ID of the AWS customer that the event source was created
#' for.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_partner_event_source(
#'   Name = "string",
#'   Account = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_delete_partner_event_source
eventbridge_delete_partner_event_source <- function(Name, Account) {
  op <- new_operation(
    name = "DeletePartnerEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$delete_partner_event_source_input(Name = Name, Account = Account)
  output <- .eventbridge$delete_partner_event_source_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$delete_partner_event_source <- eventbridge_delete_partner_event_source

#' Deletes the specified rule
#'
#' @description
#' Deletes the specified rule.
#' 
#' Before you can delete the rule, you must remove all targets, using
#' [`remove_targets`][eventbridge_remove_targets].
#' 
#' When you delete a rule, incoming events might continue to match to the
#' deleted rule. Allow a short period of time for changes to take effect.
#' 
#' Managed rules are rules created and managed by another AWS service on
#' your behalf. These rules are created by those other AWS services to
#' support functionality in those services. You can delete these rules
#' using the `Force` option, but you should do so only if you are sure the
#' other service is not still using that rule.
#'
#' @usage
#' eventbridge_delete_rule(Name, EventBusName, Force)
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#' @param Force If this is a managed rule, created by an AWS service on your behalf, you
#' must specify `Force` as `True` to delete the rule. This parameter is
#' ignored for rules that are not managed rules. You can check whether a
#' rule is a managed rule by using
#' [`describe_rule`][eventbridge_describe_rule] or
#' [`list_rules`][eventbridge_list_rules] and checking the `ManagedBy`
#' field of the response.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_rule(
#'   Name = "string",
#'   EventBusName = "string",
#'   Force = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_delete_rule
eventbridge_delete_rule <- function(Name, EventBusName = NULL, Force = NULL) {
  op <- new_operation(
    name = "DeleteRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$delete_rule_input(Name = Name, EventBusName = EventBusName, Force = Force)
  output <- .eventbridge$delete_rule_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$delete_rule <- eventbridge_delete_rule

#' Retrieves details about an archive
#'
#' @description
#' Retrieves details about an archive.
#'
#' @usage
#' eventbridge_describe_archive(ArchiveName)
#'
#' @param ArchiveName &#91;required&#93; The name of the archive to retrieve.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ArchiveArn = "string",
#'   ArchiveName = "string",
#'   EventSourceArn = "string",
#'   Description = "string",
#'   EventPattern = "string",
#'   State = "ENABLED"|"DISABLED"|"CREATING"|"UPDATING"|"CREATE_FAILED"|"UPDATE_FAILED",
#'   StateReason = "string",
#'   RetentionDays = 123,
#'   SizeBytes = 123,
#'   EventCount = 123,
#'   CreationTime = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_archive(
#'   ArchiveName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_describe_archive
eventbridge_describe_archive <- function(ArchiveName) {
  op <- new_operation(
    name = "DescribeArchive",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$describe_archive_input(ArchiveName = ArchiveName)
  output <- .eventbridge$describe_archive_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$describe_archive <- eventbridge_describe_archive

#' Displays details about an event bus in your account
#'
#' @description
#' Displays details about an event bus in your account. This can include
#' the external AWS accounts that are permitted to write events to your
#' default event bus, and the associated policy. For custom event buses and
#' partner event buses, it displays the name, ARN, policy, state, and
#' creation time.
#' 
#' To enable your account to receive events from other accounts on its
#' default event bus, use [`put_permission`][eventbridge_put_permission].
#' 
#' For more information about partner event buses, see
#' [`create_event_bus`][eventbridge_create_event_bus].
#'
#' @usage
#' eventbridge_describe_event_bus(Name)
#'
#' @param Name The name or ARN of the event bus to show details for. If you omit this,
#' the default event bus is displayed.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Name = "string",
#'   Arn = "string",
#'   Policy = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_bus(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_describe_event_bus
eventbridge_describe_event_bus <- function(Name = NULL) {
  op <- new_operation(
    name = "DescribeEventBus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$describe_event_bus_input(Name = Name)
  output <- .eventbridge$describe_event_bus_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$describe_event_bus <- eventbridge_describe_event_bus

#' This operation lists details about a partner event source that is shared
#' with your account
#'
#' @description
#' This operation lists details about a partner event source that is shared
#' with your account.
#'
#' @usage
#' eventbridge_describe_event_source(Name)
#'
#' @param Name &#91;required&#93; The name of the partner event source to display the details of.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Arn = "string",
#'   CreatedBy = "string",
#'   CreationTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ExpirationTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Name = "string",
#'   State = "PENDING"|"ACTIVE"|"DELETED"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_source(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_describe_event_source
eventbridge_describe_event_source <- function(Name) {
  op <- new_operation(
    name = "DescribeEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$describe_event_source_input(Name = Name)
  output <- .eventbridge$describe_event_source_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$describe_event_source <- eventbridge_describe_event_source

#' An SaaS partner can use this operation to list details about a partner
#' event source that they have created
#'
#' @description
#' An SaaS partner can use this operation to list details about a partner
#' event source that they have created. AWS customers do not use this
#' operation. Instead, AWS customers can use
#' [`describe_event_source`][eventbridge_describe_event_source] to see
#' details about a partner event source that is shared with them.
#'
#' @usage
#' eventbridge_describe_partner_event_source(Name)
#'
#' @param Name &#91;required&#93; The name of the event source to display.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Arn = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_partner_event_source(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_describe_partner_event_source
eventbridge_describe_partner_event_source <- function(Name) {
  op <- new_operation(
    name = "DescribePartnerEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$describe_partner_event_source_input(Name = Name)
  output <- .eventbridge$describe_partner_event_source_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$describe_partner_event_source <- eventbridge_describe_partner_event_source

#' Retrieves details about a replay
#'
#' @description
#' Retrieves details about a replay. Use
#' [`describe_replay`][eventbridge_describe_replay] to determine the
#' progress of a running replay. A replay processes events to replay based
#' on the time in the event, and replays them using 1 minute intervals. If
#' you use [`start_replay`][eventbridge_start_replay] and specify an
#' `EventStartTime` and an `EventEndTime` that covers a 20 minute time
#' range, the events are replayed from the first minute of that 20 minute
#' range first. Then the events from the second minute are replayed. You
#' can use [`describe_replay`][eventbridge_describe_replay] to determine
#' the progress of a replay. The value returned for `EventLastReplayedTime`
#' indicates the time within the specified time range associated with the
#' last event replayed.
#'
#' @usage
#' eventbridge_describe_replay(ReplayName)
#'
#' @param ReplayName &#91;required&#93; The name of the replay to retrieve.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ReplayName = "string",
#'   ReplayArn = "string",
#'   Description = "string",
#'   State = "STARTING"|"RUNNING"|"CANCELLING"|"COMPLETED"|"CANCELLED"|"FAILED",
#'   StateReason = "string",
#'   EventSourceArn = "string",
#'   Destination = list(
#'     Arn = "string",
#'     FilterArns = list(
#'       "string"
#'     )
#'   ),
#'   EventStartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EventEndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EventLastReplayedTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ReplayStartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ReplayEndTime = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_replay(
#'   ReplayName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_describe_replay
eventbridge_describe_replay <- function(ReplayName) {
  op <- new_operation(
    name = "DescribeReplay",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$describe_replay_input(ReplayName = ReplayName)
  output <- .eventbridge$describe_replay_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$describe_replay <- eventbridge_describe_replay

#' Describes the specified rule
#'
#' @description
#' Describes the specified rule.
#' 
#' DescribeRule does not list the targets of a rule. To see the targets
#' associated with a rule, use
#' [`list_targets_by_rule`][eventbridge_list_targets_by_rule].
#'
#' @usage
#' eventbridge_describe_rule(Name, EventBusName)
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Name = "string",
#'   Arn = "string",
#'   EventPattern = "string",
#'   ScheduleExpression = "string",
#'   State = "ENABLED"|"DISABLED",
#'   Description = "string",
#'   RoleArn = "string",
#'   ManagedBy = "string",
#'   EventBusName = "string",
#'   CreatedBy = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_rule(
#'   Name = "string",
#'   EventBusName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_describe_rule
eventbridge_describe_rule <- function(Name, EventBusName = NULL) {
  op <- new_operation(
    name = "DescribeRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$describe_rule_input(Name = Name, EventBusName = EventBusName)
  output <- .eventbridge$describe_rule_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$describe_rule <- eventbridge_describe_rule

#' Disables the specified rule
#'
#' @description
#' Disables the specified rule. A disabled rule won't match any events, and
#' won't self-trigger if it has a schedule expression.
#' 
#' When you disable a rule, incoming events might continue to match to the
#' disabled rule. Allow a short period of time for changes to take effect.
#'
#' @usage
#' eventbridge_disable_rule(Name, EventBusName)
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disable_rule(
#'   Name = "string",
#'   EventBusName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_disable_rule
eventbridge_disable_rule <- function(Name, EventBusName = NULL) {
  op <- new_operation(
    name = "DisableRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$disable_rule_input(Name = Name, EventBusName = EventBusName)
  output <- .eventbridge$disable_rule_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$disable_rule <- eventbridge_disable_rule

#' Enables the specified rule
#'
#' @description
#' Enables the specified rule. If the rule does not exist, the operation
#' fails.
#' 
#' When you enable a rule, incoming events might not immediately start
#' matching to a newly enabled rule. Allow a short period of time for
#' changes to take effect.
#'
#' @usage
#' eventbridge_enable_rule(Name, EventBusName)
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$enable_rule(
#'   Name = "string",
#'   EventBusName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_enable_rule
eventbridge_enable_rule <- function(Name, EventBusName = NULL) {
  op <- new_operation(
    name = "EnableRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$enable_rule_input(Name = Name, EventBusName = EventBusName)
  output <- .eventbridge$enable_rule_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$enable_rule <- eventbridge_enable_rule

#' Lists your archives
#'
#' @description
#' Lists your archives. You can either list all the archives or you can
#' provide a prefix to match to the archive names. Filter parameters are
#' exclusive.
#'
#' @usage
#' eventbridge_list_archives(NamePrefix, EventSourceArn, State, NextToken,
#'   Limit)
#'
#' @param NamePrefix A name prefix to filter the archives returned. Only archives with name
#' that match the prefix are returned.
#' @param EventSourceArn The ARN of the event source associated with the archive.
#' @param State The state of the archive.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Archives = list(
#'     list(
#'       ArchiveName = "string",
#'       EventSourceArn = "string",
#'       State = "ENABLED"|"DISABLED"|"CREATING"|"UPDATING"|"CREATE_FAILED"|"UPDATE_FAILED",
#'       StateReason = "string",
#'       RetentionDays = 123,
#'       SizeBytes = 123,
#'       EventCount = 123,
#'       CreationTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_archives(
#'   NamePrefix = "string",
#'   EventSourceArn = "string",
#'   State = "ENABLED"|"DISABLED"|"CREATING"|"UPDATING"|"CREATE_FAILED"|"UPDATE_FAILED",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_archives
eventbridge_list_archives <- function(NamePrefix = NULL, EventSourceArn = NULL, State = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListArchives",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_archives_input(NamePrefix = NamePrefix, EventSourceArn = EventSourceArn, State = State, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_archives_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_archives <- eventbridge_list_archives

#' Lists all the event buses in your account, including the default event
#' bus, custom event buses, and partner event buses
#'
#' @description
#' Lists all the event buses in your account, including the default event
#' bus, custom event buses, and partner event buses.
#'
#' @usage
#' eventbridge_list_event_buses(NamePrefix, NextToken, Limit)
#'
#' @param NamePrefix Specifying this limits the results to only those event buses with names
#' that start with the specified prefix.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit Specifying this limits the number of results returned by this operation.
#' The operation also returns a NextToken which you can use in a subsequent
#' operation to retrieve the next set of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   EventBuses = list(
#'     list(
#'       Name = "string",
#'       Arn = "string",
#'       Policy = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_event_buses(
#'   NamePrefix = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_event_buses
eventbridge_list_event_buses <- function(NamePrefix = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListEventBuses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_event_buses_input(NamePrefix = NamePrefix, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_event_buses_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_event_buses <- eventbridge_list_event_buses

#' You can use this to see all the partner event sources that have been
#' shared with your AWS account
#'
#' @description
#' You can use this to see all the partner event sources that have been
#' shared with your AWS account. For more information about partner event
#' sources, see [`create_event_bus`][eventbridge_create_event_bus].
#'
#' @usage
#' eventbridge_list_event_sources(NamePrefix, NextToken, Limit)
#'
#' @param NamePrefix Specifying this limits the results to only those partner event sources
#' with names that start with the specified prefix.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit Specifying this limits the number of results returned by this operation.
#' The operation also returns a NextToken which you can use in a subsequent
#' operation to retrieve the next set of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   EventSources = list(
#'     list(
#'       Arn = "string",
#'       CreatedBy = "string",
#'       CreationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ExpirationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Name = "string",
#'       State = "PENDING"|"ACTIVE"|"DELETED"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_event_sources(
#'   NamePrefix = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_event_sources
eventbridge_list_event_sources <- function(NamePrefix = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListEventSources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_event_sources_input(NamePrefix = NamePrefix, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_event_sources_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_event_sources <- eventbridge_list_event_sources

#' An SaaS partner can use this operation to display the AWS account ID
#' that a particular partner event source name is associated with
#'
#' @description
#' An SaaS partner can use this operation to display the AWS account ID
#' that a particular partner event source name is associated with. This
#' operation is not used by AWS customers.
#'
#' @usage
#' eventbridge_list_partner_event_source_accounts(EventSourceName,
#'   NextToken, Limit)
#'
#' @param EventSourceName &#91;required&#93; The name of the partner event source to display account information
#' about.
#' @param NextToken The token returned by a previous call to this operation. Specifying this
#' retrieves the next set of results.
#' @param Limit Specifying this limits the number of results returned by this operation.
#' The operation also returns a NextToken which you can use in a subsequent
#' operation to retrieve the next set of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PartnerEventSourceAccounts = list(
#'     list(
#'       Account = "string",
#'       CreationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ExpirationTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       State = "PENDING"|"ACTIVE"|"DELETED"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_partner_event_source_accounts(
#'   EventSourceName = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_partner_event_source_accounts
eventbridge_list_partner_event_source_accounts <- function(EventSourceName, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListPartnerEventSourceAccounts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_partner_event_source_accounts_input(EventSourceName = EventSourceName, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_partner_event_source_accounts_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_partner_event_source_accounts <- eventbridge_list_partner_event_source_accounts

#' An SaaS partner can use this operation to list all the partner event
#' source names that they have created
#'
#' @description
#' An SaaS partner can use this operation to list all the partner event
#' source names that they have created. This operation is not used by AWS
#' customers.
#'
#' @usage
#' eventbridge_list_partner_event_sources(NamePrefix, NextToken, Limit)
#'
#' @param NamePrefix &#91;required&#93; If you specify this, the results are limited to only those partner event
#' sources that start with the string you specify.
#' @param NextToken The token returned by a previous call to this operation. Specifying this
#' retrieves the next set of results.
#' @param Limit pecifying this limits the number of results returned by this operation.
#' The operation also returns a NextToken which you can use in a subsequent
#' operation to retrieve the next set of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PartnerEventSources = list(
#'     list(
#'       Arn = "string",
#'       Name = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_partner_event_sources(
#'   NamePrefix = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_partner_event_sources
eventbridge_list_partner_event_sources <- function(NamePrefix, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListPartnerEventSources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_partner_event_sources_input(NamePrefix = NamePrefix, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_partner_event_sources_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_partner_event_sources <- eventbridge_list_partner_event_sources

#' Lists your replays
#'
#' @description
#' Lists your replays. You can either list all the replays or you can
#' provide a prefix to match to the replay names. Filter parameters are
#' exclusive.
#'
#' @usage
#' eventbridge_list_replays(NamePrefix, State, EventSourceArn, NextToken,
#'   Limit)
#'
#' @param NamePrefix A name prefix to filter the replays returned. Only replays with name
#' that match the prefix are returned.
#' @param State The state of the replay.
#' @param EventSourceArn The ARN of the event source associated with the replay.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of replays to retrieve.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Replays = list(
#'     list(
#'       ReplayName = "string",
#'       EventSourceArn = "string",
#'       State = "STARTING"|"RUNNING"|"CANCELLING"|"COMPLETED"|"CANCELLED"|"FAILED",
#'       StateReason = "string",
#'       EventStartTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       EventEndTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       EventLastReplayedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ReplayStartTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ReplayEndTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_replays(
#'   NamePrefix = "string",
#'   State = "STARTING"|"RUNNING"|"CANCELLING"|"COMPLETED"|"CANCELLED"|"FAILED",
#'   EventSourceArn = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_replays
eventbridge_list_replays <- function(NamePrefix = NULL, State = NULL, EventSourceArn = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListReplays",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_replays_input(NamePrefix = NamePrefix, State = State, EventSourceArn = EventSourceArn, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_replays_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_replays <- eventbridge_list_replays

#' Lists the rules for the specified target
#'
#' @description
#' Lists the rules for the specified target. You can see which of the rules
#' in Amazon EventBridge can invoke a specific target in your account.
#'
#' @usage
#' eventbridge_list_rule_names_by_target(TargetArn, EventBusName,
#'   NextToken, Limit)
#'
#' @param TargetArn &#91;required&#93; The Amazon Resource Name (ARN) of the target resource.
#' @param EventBusName The name or ARN of the event bus to list rules for. If you omit this,
#' the default event bus is used.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RuleNames = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_rule_names_by_target(
#'   TargetArn = "string",
#'   EventBusName = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_rule_names_by_target
eventbridge_list_rule_names_by_target <- function(TargetArn, EventBusName = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRuleNamesByTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_rule_names_by_target_input(TargetArn = TargetArn, EventBusName = EventBusName, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_rule_names_by_target_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_rule_names_by_target <- eventbridge_list_rule_names_by_target

#' Lists your Amazon EventBridge rules
#'
#' @description
#' Lists your Amazon EventBridge rules. You can either list all the rules
#' or you can provide a prefix to match to the rule names.
#' 
#' ListRules does not list the targets of a rule. To see the targets
#' associated with a rule, use
#' [`list_targets_by_rule`][eventbridge_list_targets_by_rule].
#'
#' @usage
#' eventbridge_list_rules(NamePrefix, EventBusName, NextToken, Limit)
#'
#' @param NamePrefix The prefix matching the rule name.
#' @param EventBusName The name or ARN of the event bus to list the rules for. If you omit
#' this, the default event bus is used.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Rules = list(
#'     list(
#'       Name = "string",
#'       Arn = "string",
#'       EventPattern = "string",
#'       State = "ENABLED"|"DISABLED",
#'       Description = "string",
#'       ScheduleExpression = "string",
#'       RoleArn = "string",
#'       ManagedBy = "string",
#'       EventBusName = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_rules(
#'   NamePrefix = "string",
#'   EventBusName = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_rules
eventbridge_list_rules <- function(NamePrefix = NULL, EventBusName = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_rules_input(NamePrefix = NamePrefix, EventBusName = EventBusName, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_rules_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_rules <- eventbridge_list_rules

#' Displays the tags associated with an EventBridge resource
#'
#' @description
#' Displays the tags associated with an EventBridge resource. In
#' EventBridge, rules and event buses can be tagged.
#'
#' @usage
#' eventbridge_list_tags_for_resource(ResourceARN)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the EventBridge resource for which you want to view tags.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_tags_for_resource
eventbridge_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .eventbridge$list_tags_for_resource_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_tags_for_resource <- eventbridge_list_tags_for_resource

#' Lists the targets assigned to the specified rule
#'
#' @description
#' Lists the targets assigned to the specified rule.
#'
#' @usage
#' eventbridge_list_targets_by_rule(Rule, EventBusName, NextToken, Limit)
#'
#' @param Rule &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Targets = list(
#'     list(
#'       Id = "string",
#'       Arn = "string",
#'       RoleArn = "string",
#'       Input = "string",
#'       InputPath = "string",
#'       InputTransformer = list(
#'         InputPathsMap = list(
#'           "string"
#'         ),
#'         InputTemplate = "string"
#'       ),
#'       KinesisParameters = list(
#'         PartitionKeyPath = "string"
#'       ),
#'       RunCommandParameters = list(
#'         RunCommandTargets = list(
#'           list(
#'             Key = "string",
#'             Values = list(
#'               "string"
#'             )
#'           )
#'         )
#'       ),
#'       EcsParameters = list(
#'         TaskDefinitionArn = "string",
#'         TaskCount = 123,
#'         LaunchType = "EC2"|"FARGATE",
#'         NetworkConfiguration = list(
#'           awsvpcConfiguration = list(
#'             Subnets = list(
#'               "string"
#'             ),
#'             SecurityGroups = list(
#'               "string"
#'             ),
#'             AssignPublicIp = "ENABLED"|"DISABLED"
#'           )
#'         ),
#'         PlatformVersion = "string",
#'         Group = "string"
#'       ),
#'       BatchParameters = list(
#'         JobDefinition = "string",
#'         JobName = "string",
#'         ArrayProperties = list(
#'           Size = 123
#'         ),
#'         RetryStrategy = list(
#'           Attempts = 123
#'         )
#'       ),
#'       SqsParameters = list(
#'         MessageGroupId = "string"
#'       ),
#'       HttpParameters = list(
#'         PathParameterValues = list(
#'           "string"
#'         ),
#'         HeaderParameters = list(
#'           "string"
#'         ),
#'         QueryStringParameters = list(
#'           "string"
#'         )
#'       ),
#'       RedshiftDataParameters = list(
#'         SecretManagerArn = "string",
#'         Database = "string",
#'         DbUser = "string",
#'         Sql = "string",
#'         StatementName = "string",
#'         WithEvent = TRUE|FALSE
#'       ),
#'       DeadLetterConfig = list(
#'         Arn = "string"
#'       ),
#'       RetryPolicy = list(
#'         MaximumRetryAttempts = 123,
#'         MaximumEventAgeInSeconds = 123
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_targets_by_rule(
#'   Rule = "string",
#'   EventBusName = "string",
#'   NextToken = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_targets_by_rule
eventbridge_list_targets_by_rule <- function(Rule, EventBusName = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTargetsByRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_targets_by_rule_input(Rule = Rule, EventBusName = EventBusName, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_targets_by_rule_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_targets_by_rule <- eventbridge_list_targets_by_rule

#' Sends custom events to Amazon EventBridge so that they can be matched to
#' rules
#'
#' @description
#' Sends custom events to Amazon EventBridge so that they can be matched to
#' rules.
#'
#' @usage
#' eventbridge_put_events(Entries)
#'
#' @param Entries &#91;required&#93; The entry that defines an event in your system. You can specify several
#' parameters for the entry such as the source and type of the event,
#' resources associated with the event, and so on.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FailedEntryCount = 123,
#'   Entries = list(
#'     list(
#'       EventId = "string",
#'       ErrorCode = "string",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_events(
#'   Entries = list(
#'     list(
#'       Time = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Source = "string",
#'       Resources = list(
#'         "string"
#'       ),
#'       DetailType = "string",
#'       Detail = "string",
#'       EventBusName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_put_events
eventbridge_put_events <- function(Entries) {
  op <- new_operation(
    name = "PutEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$put_events_input(Entries = Entries)
  output <- .eventbridge$put_events_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$put_events <- eventbridge_put_events

#' This is used by SaaS partners to write events to a customer's partner
#' event bus
#'
#' @description
#' This is used by SaaS partners to write events to a customer's partner
#' event bus. AWS customers do not use this operation.
#'
#' @usage
#' eventbridge_put_partner_events(Entries)
#'
#' @param Entries &#91;required&#93; The list of events to write to the event bus.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FailedEntryCount = 123,
#'   Entries = list(
#'     list(
#'       EventId = "string",
#'       ErrorCode = "string",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_partner_events(
#'   Entries = list(
#'     list(
#'       Time = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Source = "string",
#'       Resources = list(
#'         "string"
#'       ),
#'       DetailType = "string",
#'       Detail = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_put_partner_events
eventbridge_put_partner_events <- function(Entries) {
  op <- new_operation(
    name = "PutPartnerEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$put_partner_events_input(Entries = Entries)
  output <- .eventbridge$put_partner_events_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$put_partner_events <- eventbridge_put_partner_events

#' Running PutPermission permits the specified AWS account or AWS
#' organization to put events to the specified event bus
#'
#' @description
#' Running [`put_permission`][eventbridge_put_permission] permits the
#' specified AWS account or AWS organization to put events to the specified
#' *event bus*. Amazon EventBridge (CloudWatch Events) rules in your
#' account are triggered by these events arriving to an event bus in your
#' account.
#' 
#' For another account to send events to your account, that external
#' account must have an EventBridge rule with your account's event bus as a
#' target.
#' 
#' To enable multiple AWS accounts to put events to your event bus, run
#' [`put_permission`][eventbridge_put_permission] once for each of these
#' accounts. Or, if all the accounts are members of the same AWS
#' organization, you can run [`put_permission`][eventbridge_put_permission]
#' once specifying `Principal` as "*" and specifying the AWS organization
#' ID in `Condition`, to grant permissions to all accounts in that
#' organization.
#' 
#' If you grant permissions using an organization, then accounts in that
#' organization must specify a `RoleArn` with proper permissions when they
#' use `PutTarget` to add your account's event bus as a target. For more
#' information, see [Sending and Receiving Events Between AWS
#' Accounts](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-cross-account.html)
#' in the *Amazon EventBridge User Guide*.
#' 
#' The permission policy on the default event bus cannot exceed 10 KB in
#' size.
#'
#' @usage
#' eventbridge_put_permission(EventBusName, Action, Principal, StatementId,
#'   Condition, Policy)
#'
#' @param EventBusName The name of the event bus associated with the rule. If you omit this,
#' the default event bus is used.
#' @param Action The action that you are enabling the other account to perform.
#' Currently, this must be `events:PutEvents`.
#' @param Principal The 12-digit AWS account ID that you are permitting to put events to
#' your default event bus. Specify "*" to permit any account to put events
#' to your default event bus.
#' 
#' If you specify "*" without specifying `Condition`, avoid creating rules
#' that may match undesirable events. To create more secure rules, make
#' sure that the event pattern for each rule contains an `account` field
#' with a specific account ID from which to receive events. Rules with an
#' account field do not match any events sent from other accounts.
#' @param StatementId An identifier string for the external account that you are granting
#' permissions to. If you later want to revoke the permission for this
#' external account, specify this `StatementId` when you run
#' [`remove_permission`][eventbridge_remove_permission].
#' @param Condition This parameter enables you to limit the permission to accounts that
#' fulfill a certain condition, such as being a member of a certain AWS
#' organization. For more information about AWS Organizations, see [What Is
#' AWS
#' Organizations](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html)
#' in the *AWS Organizations User Guide*.
#' 
#' If you specify `Condition` with an AWS organization ID, and specify "*"
#' as the value for `Principal`, you grant permission to all the accounts
#' in the named organization.
#' 
#' The `Condition` is a JSON string which must contain `Type`, `Key`, and
#' `Value` fields.
#' @param Policy A JSON string that describes the permission policy statement. You can
#' include a `Policy` parameter in the request instead of using the
#' `StatementId`, `Action`, `Principal`, or `Condition` parameters.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$put_permission(
#'   EventBusName = "string",
#'   Action = "string",
#'   Principal = "string",
#'   StatementId = "string",
#'   Condition = list(
#'     Type = "string",
#'     Key = "string",
#'     Value = "string"
#'   ),
#'   Policy = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_put_permission
eventbridge_put_permission <- function(EventBusName = NULL, Action = NULL, Principal = NULL, StatementId = NULL, Condition = NULL, Policy = NULL) {
  op <- new_operation(
    name = "PutPermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$put_permission_input(EventBusName = EventBusName, Action = Action, Principal = Principal, StatementId = StatementId, Condition = Condition, Policy = Policy)
  output <- .eventbridge$put_permission_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$put_permission <- eventbridge_put_permission

#' Creates or updates the specified rule
#'
#' @description
#' Creates or updates the specified rule. Rules are enabled by default, or
#' based on value of the state. You can disable a rule using
#' [`disable_rule`][eventbridge_disable_rule].
#' 
#' A single rule watches for events from a single event bus. Events
#' generated by AWS services go to your account's default event bus. Events
#' generated by SaaS partner services or applications go to the matching
#' partner event bus. If you have custom applications or services, you can
#' specify whether their events go to your default event bus or a custom
#' event bus that you have created. For more information, see
#' [`create_event_bus`][eventbridge_create_event_bus].
#' 
#' If you are updating an existing rule, the rule is replaced with what you
#' specify in this [`put_rule`][eventbridge_put_rule] command. If you omit
#' arguments in [`put_rule`][eventbridge_put_rule], the old values for
#' those arguments are not kept. Instead, they are replaced with null
#' values.
#' 
#' When you create or update a rule, incoming events might not immediately
#' start matching to new or updated rules. Allow a short period of time for
#' changes to take effect.
#' 
#' A rule must contain at least an EventPattern or ScheduleExpression.
#' Rules with EventPatterns are triggered when a matching event is
#' observed. Rules with ScheduleExpressions self-trigger based on the given
#' schedule. A rule can have both an EventPattern and a ScheduleExpression,
#' in which case the rule triggers on matching events as well as on a
#' schedule.
#' 
#' When you initially create a rule, you can optionally assign one or more
#' tags to the rule. Tags can help you organize and categorize your
#' resources. You can also use them to scope user permissions, by granting
#' a user permission to access or change only rules with certain tag
#' values. To use the [`put_rule`][eventbridge_put_rule] operation and
#' assign tags, you must have both the `events:PutRule` and
#' `events:TagResource` permissions.
#' 
#' If you are updating an existing rule, any tags you specify in the
#' [`put_rule`][eventbridge_put_rule] operation are ignored. To update the
#' tags of an existing rule, use [`tag_resource`][eventbridge_tag_resource]
#' and [`untag_resource`][eventbridge_untag_resource].
#' 
#' Most services in AWS treat : or / as the same character in Amazon
#' Resource Names (ARNs). However, EventBridge uses an exact match in event
#' patterns and rules. Be sure to use the correct ARN characters when
#' creating event patterns so that they match the ARN syntax in the event
#' you want to match.
#' 
#' In EventBridge, it is possible to create rules that lead to infinite
#' loops, where a rule is fired repeatedly. For example, a rule might
#' detect that ACLs have changed on an S3 bucket, and trigger software to
#' change them to the desired state. If the rule is not written carefully,
#' the subsequent change to the ACLs fires the rule again, creating an
#' infinite loop.
#' 
#' To prevent this, write the rules so that the triggered actions do not
#' re-fire the same rule. For example, your rule could fire only if ACLs
#' are found to be in a bad state, instead of after any change.
#' 
#' An infinite loop can quickly cause higher than expected charges. We
#' recommend that you use budgeting, which alerts you when charges exceed
#' your specified limit. For more information, see [Managing Your Costs
#' with
#' Budgets](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html).
#'
#' @usage
#' eventbridge_put_rule(Name, ScheduleExpression, EventPattern, State,
#'   Description, RoleArn, Tags, EventBusName)
#'
#' @param Name &#91;required&#93; The name of the rule that you are creating or updating.
#' @param ScheduleExpression The scheduling expression. For example, "cron(0 20 * * ? *)" or
#' "rate(5 minutes)".
#' @param EventPattern The event pattern. For more information, see [Events and Event
#' Patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html)
#' in the *Amazon EventBridge User Guide*.
#' @param State Indicates whether the rule is enabled or disabled.
#' @param Description A description of the rule.
#' @param RoleArn The Amazon Resource Name (ARN) of the IAM role associated with the rule.
#' @param Tags The list of key-value pairs to associate with the rule.
#' @param EventBusName The name or ARN of the event bus to associate with this rule. If you
#' omit this, the default event bus is used.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RuleArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_rule(
#'   Name = "string",
#'   ScheduleExpression = "string",
#'   EventPattern = "string",
#'   State = "ENABLED"|"DISABLED",
#'   Description = "string",
#'   RoleArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   EventBusName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_put_rule
eventbridge_put_rule <- function(Name, ScheduleExpression = NULL, EventPattern = NULL, State = NULL, Description = NULL, RoleArn = NULL, Tags = NULL, EventBusName = NULL) {
  op <- new_operation(
    name = "PutRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$put_rule_input(Name = Name, ScheduleExpression = ScheduleExpression, EventPattern = EventPattern, State = State, Description = Description, RoleArn = RoleArn, Tags = Tags, EventBusName = EventBusName)
  output <- .eventbridge$put_rule_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$put_rule <- eventbridge_put_rule

#' Adds the specified targets to the specified rule, or updates the targets
#' if they are already associated with the rule
#'
#' @description
#' Adds the specified targets to the specified rule, or updates the targets
#' if they are already associated with the rule.
#' 
#' Targets are the resources that are invoked when a rule is triggered.
#' 
#' You can configure the following as targets for Events:
#' 
#' -   EC2 instances
#' 
#' -   SSM Run Command
#' 
#' -   SSM Automation
#' 
#' -   AWS Lambda functions
#' 
#' -   Data streams in Amazon Kinesis Data Streams
#' 
#' -   Data delivery streams in Amazon Kinesis Data Firehose
#' 
#' -   Amazon ECS tasks
#' 
#' -   AWS Step Functions state machines
#' 
#' -   AWS Batch jobs
#' 
#' -   AWS CodeBuild projects
#' 
#' -   Pipelines in AWS CodePipeline
#' 
#' -   Amazon Inspector assessment templates
#' 
#' -   Amazon SNS topics
#' 
#' -   Amazon SQS queues, including FIFO queues
#' 
#' -   The default event bus of another AWS account
#' 
#' -   Amazon API Gateway REST APIs
#' 
#' -   Redshift Clusters to invoke Data API ExecuteStatement on
#' 
#' Creating rules with built-in targets is supported only in the AWS
#' Management Console. The built-in targets are
#' `EC2 CreateSnapshot API call`, `EC2 RebootInstances API call`,
#' `EC2 StopInstances API call`, and `EC2 TerminateInstances API call`.
#' 
#' For some target types, [`put_targets`][eventbridge_put_targets] provides
#' target-specific parameters. If the target is a Kinesis data stream, you
#' can optionally specify which shard the event goes to by using the
#' `KinesisParameters` argument. To invoke a command on multiple EC2
#' instances with one rule, you can use the `RunCommandParameters` field.
#' 
#' To be able to make API calls against the resources that you own, Amazon
#' EventBridge (CloudWatch Events) needs the appropriate permissions. For
#' AWS Lambda and Amazon SNS resources, EventBridge relies on
#' resource-based policies. For EC2 instances, Kinesis data streams, AWS
#' Step Functions state machines and API Gateway REST APIs, EventBridge
#' relies on IAM roles that you specify in the `RoleARN` argument in
#' [`put_targets`][eventbridge_put_targets]. For more information, see
#' [Authentication and Access
#' Control](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-iam.html)
#' in the *Amazon EventBridge User Guide*.
#' 
#' If another AWS account is in the same region and has granted you
#' permission (using [`put_permission`][eventbridge_put_permission]), you
#' can send events to that account. Set that account's event bus as a
#' target of the rules in your account. To send the matched events to the
#' other account, specify that account's event bus as the `Arn` value when
#' you run [`put_targets`][eventbridge_put_targets]. If your account sends
#' events to another account, your account is charged for each sent event.
#' Each event sent to another account is charged as a custom event. The
#' account receiving the event is not charged. For more information, see
#' [Amazon EventBridge (CloudWatch Events)
#' Pricing](https://aws.amazon.com/eventbridge/pricing/).
#' 
#' `Input`, `InputPath`, and `InputTransformer` are not available with
#' `PutTarget` if the target is an event bus of a different AWS account.
#' 
#' If you are setting the event bus of another account as the target, and
#' that account granted permission to your account through an organization
#' instead of directly by the account ID, then you must specify a `RoleArn`
#' with proper permissions in the `Target` structure. For more information,
#' see [Sending and Receiving Events Between AWS
#' Accounts](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-cross-account.html)
#' in the *Amazon EventBridge User Guide*.
#' 
#' For more information about enabling cross-account events, see
#' [`put_permission`][eventbridge_put_permission].
#' 
#' **Input**, **InputPath**, and **InputTransformer** are mutually
#' exclusive and optional parameters of a target. When a rule is triggered
#' due to a matched event:
#' 
#' -   If none of the following arguments are specified for a target, then
#'     the entire event is passed to the target in JSON format (unless the
#'     target is Amazon EC2 Run Command or Amazon ECS task, in which case
#'     nothing from the event is passed to the target).
#' 
#' -   If **Input** is specified in the form of valid JSON, then the
#'     matched event is overridden with this constant.
#' 
#' -   If **InputPath** is specified in the form of JSONPath (for example,
#'     `$.detail`), then only the part of the event specified in the path
#'     is passed to the target (for example, only the detail part of the
#'     event is passed).
#' 
#' -   If **InputTransformer** is specified, then one or more specified
#'     JSONPaths are extracted from the event and used as values in a
#'     template that you specify as the input to the target.
#' 
#' When you specify `InputPath` or `InputTransformer`, you must use JSON
#' dot notation, not bracket notation.
#' 
#' When you add targets to a rule and the associated rule triggers soon
#' after, new or updated targets might not be immediately invoked. Allow a
#' short period of time for changes to take effect.
#' 
#' This action can partially fail if too many requests are made at the same
#' time. If that happens, `FailedEntryCount` is non-zero in the response
#' and each entry in `FailedEntries` provides the ID of the failed target
#' and the error code.
#'
#' @usage
#' eventbridge_put_targets(Rule, EventBusName, Targets)
#'
#' @param Rule &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#' @param Targets &#91;required&#93; The targets to update or add to the rule.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FailedEntryCount = 123,
#'   FailedEntries = list(
#'     list(
#'       TargetId = "string",
#'       ErrorCode = "string",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_targets(
#'   Rule = "string",
#'   EventBusName = "string",
#'   Targets = list(
#'     list(
#'       Id = "string",
#'       Arn = "string",
#'       RoleArn = "string",
#'       Input = "string",
#'       InputPath = "string",
#'       InputTransformer = list(
#'         InputPathsMap = list(
#'           "string"
#'         ),
#'         InputTemplate = "string"
#'       ),
#'       KinesisParameters = list(
#'         PartitionKeyPath = "string"
#'       ),
#'       RunCommandParameters = list(
#'         RunCommandTargets = list(
#'           list(
#'             Key = "string",
#'             Values = list(
#'               "string"
#'             )
#'           )
#'         )
#'       ),
#'       EcsParameters = list(
#'         TaskDefinitionArn = "string",
#'         TaskCount = 123,
#'         LaunchType = "EC2"|"FARGATE",
#'         NetworkConfiguration = list(
#'           awsvpcConfiguration = list(
#'             Subnets = list(
#'               "string"
#'             ),
#'             SecurityGroups = list(
#'               "string"
#'             ),
#'             AssignPublicIp = "ENABLED"|"DISABLED"
#'           )
#'         ),
#'         PlatformVersion = "string",
#'         Group = "string"
#'       ),
#'       BatchParameters = list(
#'         JobDefinition = "string",
#'         JobName = "string",
#'         ArrayProperties = list(
#'           Size = 123
#'         ),
#'         RetryStrategy = list(
#'           Attempts = 123
#'         )
#'       ),
#'       SqsParameters = list(
#'         MessageGroupId = "string"
#'       ),
#'       HttpParameters = list(
#'         PathParameterValues = list(
#'           "string"
#'         ),
#'         HeaderParameters = list(
#'           "string"
#'         ),
#'         QueryStringParameters = list(
#'           "string"
#'         )
#'       ),
#'       RedshiftDataParameters = list(
#'         SecretManagerArn = "string",
#'         Database = "string",
#'         DbUser = "string",
#'         Sql = "string",
#'         StatementName = "string",
#'         WithEvent = TRUE|FALSE
#'       ),
#'       DeadLetterConfig = list(
#'         Arn = "string"
#'       ),
#'       RetryPolicy = list(
#'         MaximumRetryAttempts = 123,
#'         MaximumEventAgeInSeconds = 123
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_put_targets
eventbridge_put_targets <- function(Rule, EventBusName = NULL, Targets) {
  op <- new_operation(
    name = "PutTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$put_targets_input(Rule = Rule, EventBusName = EventBusName, Targets = Targets)
  output <- .eventbridge$put_targets_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$put_targets <- eventbridge_put_targets

#' Revokes the permission of another AWS account to be able to put events
#' to the specified event bus
#'
#' @description
#' Revokes the permission of another AWS account to be able to put events
#' to the specified event bus. Specify the account to revoke by the
#' `StatementId` value that you associated with the account when you
#' granted it permission with
#' [`put_permission`][eventbridge_put_permission]. You can find the
#' `StatementId` by using
#' [`describe_event_bus`][eventbridge_describe_event_bus].
#'
#' @usage
#' eventbridge_remove_permission(StatementId, RemoveAllPermissions,
#'   EventBusName)
#'
#' @param StatementId The statement ID corresponding to the account that is no longer allowed
#' to put events to the default event bus.
#' @param RemoveAllPermissions Specifies whether to remove all permissions.
#' @param EventBusName The name of the event bus to revoke permissions for. If you omit this,
#' the default event bus is used.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$remove_permission(
#'   StatementId = "string",
#'   RemoveAllPermissions = TRUE|FALSE,
#'   EventBusName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_remove_permission
eventbridge_remove_permission <- function(StatementId = NULL, RemoveAllPermissions = NULL, EventBusName = NULL) {
  op <- new_operation(
    name = "RemovePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$remove_permission_input(StatementId = StatementId, RemoveAllPermissions = RemoveAllPermissions, EventBusName = EventBusName)
  output <- .eventbridge$remove_permission_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$remove_permission <- eventbridge_remove_permission

#' Removes the specified targets from the specified rule
#'
#' @description
#' Removes the specified targets from the specified rule. When the rule is
#' triggered, those targets are no longer be invoked.
#' 
#' When you remove a target, when the associated rule triggers, removed
#' targets might continue to be invoked. Allow a short period of time for
#' changes to take effect.
#' 
#' This action can partially fail if too many requests are made at the same
#' time. If that happens, `FailedEntryCount` is non-zero in the response
#' and each entry in `FailedEntries` provides the ID of the failed target
#' and the error code.
#'
#' @usage
#' eventbridge_remove_targets(Rule, EventBusName, Ids, Force)
#'
#' @param Rule &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#' @param Ids &#91;required&#93; The IDs of the targets to remove from the rule.
#' @param Force If this is a managed rule, created by an AWS service on your behalf, you
#' must specify `Force` as `True` to remove targets. This parameter is
#' ignored for rules that are not managed rules. You can check whether a
#' rule is a managed rule by using
#' [`describe_rule`][eventbridge_describe_rule] or
#' [`list_rules`][eventbridge_list_rules] and checking the `ManagedBy`
#' field of the response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   FailedEntryCount = 123,
#'   FailedEntries = list(
#'     list(
#'       TargetId = "string",
#'       ErrorCode = "string",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$remove_targets(
#'   Rule = "string",
#'   EventBusName = "string",
#'   Ids = list(
#'     "string"
#'   ),
#'   Force = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_remove_targets
eventbridge_remove_targets <- function(Rule, EventBusName = NULL, Ids, Force = NULL) {
  op <- new_operation(
    name = "RemoveTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$remove_targets_input(Rule = Rule, EventBusName = EventBusName, Ids = Ids, Force = Force)
  output <- .eventbridge$remove_targets_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$remove_targets <- eventbridge_remove_targets

#' Starts the specified replay
#'
#' @description
#' Starts the specified replay. Events are not necessarily replayed in the
#' exact same order that they were added to the archive. A replay processes
#' events to replay based on the time in the event, and replays them using
#' 1 minute intervals. If you specify an `EventStartTime` and an
#' `EventEndTime` that covers a 20 minute time range, the events are
#' replayed from the first minute of that 20 minute range first. Then the
#' events from the second minute are replayed. You can use
#' [`describe_replay`][eventbridge_describe_replay] to determine the
#' progress of a replay. The value returned for `EventLastReplayedTime`
#' indicates the time within the specified time range associated with the
#' last event replayed.
#'
#' @usage
#' eventbridge_start_replay(ReplayName, Description, EventSourceArn,
#'   EventStartTime, EventEndTime, Destination)
#'
#' @param ReplayName &#91;required&#93; The name of the replay to start.
#' @param Description A description for the replay to start.
#' @param EventSourceArn &#91;required&#93; The ARN of the archive to replay events from.
#' @param EventStartTime &#91;required&#93; A time stamp for the time to start replaying events. Only events that
#' occurred between the `EventStartTime` and `EventEndTime` are replayed.
#' @param EventEndTime &#91;required&#93; A time stamp for the time to stop replaying events. Only events that
#' occurred between the `EventStartTime` and `EventEndTime` are replayed.
#' @param Destination &#91;required&#93; A `ReplayDestination` object that includes details about the destination
#' for the replay.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ReplayArn = "string",
#'   State = "STARTING"|"RUNNING"|"CANCELLING"|"COMPLETED"|"CANCELLED"|"FAILED",
#'   StateReason = "string",
#'   ReplayStartTime = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_replay(
#'   ReplayName = "string",
#'   Description = "string",
#'   EventSourceArn = "string",
#'   EventStartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EventEndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Destination = list(
#'     Arn = "string",
#'     FilterArns = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_start_replay
eventbridge_start_replay <- function(ReplayName, Description = NULL, EventSourceArn, EventStartTime, EventEndTime, Destination) {
  op <- new_operation(
    name = "StartReplay",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$start_replay_input(ReplayName = ReplayName, Description = Description, EventSourceArn = EventSourceArn, EventStartTime = EventStartTime, EventEndTime = EventEndTime, Destination = Destination)
  output <- .eventbridge$start_replay_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$start_replay <- eventbridge_start_replay

#' Assigns one or more tags (key-value pairs) to the specified EventBridge
#' resource
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified EventBridge
#' resource. Tags can help you organize and categorize your resources. You
#' can also use them to scope user permissions by granting a user
#' permission to access or change only resources with certain tag values.
#' In EventBridge, rules and event buses can be tagged.
#' 
#' Tags don't have any semantic meaning to AWS and are interpreted strictly
#' as strings of characters.
#' 
#' You can use the [`tag_resource`][eventbridge_tag_resource] action with a
#' resource that already has tags. If you specify a new tag key, this tag
#' is appended to the list of tags associated with the resource. If you
#' specify a tag key that is already associated with the resource, the new
#' tag value that you specify replaces the previous value for that tag.
#' 
#' You can associate as many as 50 tags with a resource.
#'
#' @usage
#' eventbridge_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the EventBridge resource that you're adding tags to.
#' @param Tags &#91;required&#93; The list of key-value pairs to associate with the resource.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_tag_resource
eventbridge_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .eventbridge$tag_resource_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$tag_resource <- eventbridge_tag_resource

#' Tests whether the specified event pattern matches the provided event
#'
#' @description
#' Tests whether the specified event pattern matches the provided event.
#' 
#' Most services in AWS treat : or / as the same character in Amazon
#' Resource Names (ARNs). However, EventBridge uses an exact match in event
#' patterns and rules. Be sure to use the correct ARN characters when
#' creating event patterns so that they match the ARN syntax in the event
#' you want to match.
#'
#' @usage
#' eventbridge_test_event_pattern(EventPattern, Event)
#'
#' @param EventPattern &#91;required&#93; The event pattern. For more information, see [Events and Event
#' Patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html)
#' in the *Amazon EventBridge User Guide*.
#' @param Event &#91;required&#93; The event, in JSON format, to test against the event pattern.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Result = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$test_event_pattern(
#'   EventPattern = "string",
#'   Event = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_test_event_pattern
eventbridge_test_event_pattern <- function(EventPattern, Event) {
  op <- new_operation(
    name = "TestEventPattern",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$test_event_pattern_input(EventPattern = EventPattern, Event = Event)
  output <- .eventbridge$test_event_pattern_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$test_event_pattern <- eventbridge_test_event_pattern

#' Removes one or more tags from the specified EventBridge resource
#'
#' @description
#' Removes one or more tags from the specified EventBridge resource. In
#' Amazon EventBridge (CloudWatch Events, rules and event buses can be
#' tagged.
#'
#' @usage
#' eventbridge_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the EventBridge resource from which you are removing tags.
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_untag_resource
eventbridge_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .eventbridge$untag_resource_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$untag_resource <- eventbridge_untag_resource

#' Updates the specified archive
#'
#' @description
#' Updates the specified archive.
#'
#' @usage
#' eventbridge_update_archive(ArchiveName, Description, EventPattern,
#'   RetentionDays)
#'
#' @param ArchiveName &#91;required&#93; The name of the archive to update.
#' @param Description The description for the archive.
#' @param EventPattern The event pattern to use to filter events sent to the archive.
#' @param RetentionDays The number of days to retain events in the archive.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ArchiveArn = "string",
#'   State = "ENABLED"|"DISABLED"|"CREATING"|"UPDATING"|"CREATE_FAILED"|"UPDATE_FAILED",
#'   StateReason = "string",
#'   CreationTime = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_archive(
#'   ArchiveName = "string",
#'   Description = "string",
#'   EventPattern = "string",
#'   RetentionDays = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eventbridge_update_archive
eventbridge_update_archive <- function(ArchiveName, Description = NULL, EventPattern = NULL, RetentionDays = NULL) {
  op <- new_operation(
    name = "UpdateArchive",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$update_archive_input(ArchiveName = ArchiveName, Description = Description, EventPattern = EventPattern, RetentionDays = RetentionDays)
  output <- .eventbridge$update_archive_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$update_archive <- eventbridge_update_archive
