% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_list_queues}
\alias{sqs_list_queues}
\title{Returns a list of your queues}
\usage{
sqs_list_queues(QueueNamePrefix)
}
\arguments{
\item{QueueNamePrefix}{A string to use for filtering the list results. Only those queues whose
name begins with the specified string are returned.

Queue URLs and names are case-sensitive.}
}
\description{
Returns a list of your queues. The maximum number of queues that can be
returned is 1,000. If you specify a value for the optional
\code{QueueNamePrefix} parameter, only queues with a name that begins with
the specified value are returned.
}
\details{
Cross-account permissions don\'t apply to this action. For more
information, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name}{Grant Cross-Account Permissions to a Role and a User Name}
in the \emph{Amazon Simple Queue Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_queues(
  QueueNamePrefix = "string"
)
}
}

\keyword{internal}
