% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_subscribe}
\alias{sns_subscribe}
\title{Prepares to subscribe an endpoint by sending the endpoint a confirmation
message}
\usage{
sns_subscribe(TopicArn, Protocol, Endpoint, Attributes,
  ReturnSubscriptionArn)
}
\arguments{
\item{TopicArn}{[required] The ARN of the topic you want to subscribe to.}

\item{Protocol}{[required] The protocol you want to use. Supported protocols include:
\itemize{
\item \code{http} -- delivery of JSON-encoded message via HTTP POST
\item \code{https} -- delivery of JSON-encoded message via HTTPS POST
\item \code{email} -- delivery of message via SMTP
\item \code{email-json} -- delivery of JSON-encoded message via SMTP
\item \code{sms} -- delivery of message via SMS
\item \code{sqs} -- delivery of JSON-encoded message to an Amazon SQS queue
\item \code{application} -- delivery of JSON-encoded message to an EndpointArn
for a mobile app and device.
\item \code{lambda} -- delivery of JSON-encoded message to an Amazon Lambda
function.
}}

\item{Endpoint}{The endpoint that you want to receive notifications. Endpoints vary by
protocol:
\itemize{
\item For the \code{http} protocol, the endpoint is an URL beginning with
\verb{http://}
\item For the \code{https} protocol, the endpoint is a URL beginning with
\verb{https://}
\item For the \code{email} protocol, the endpoint is an email address
\item For the \code{email-json} protocol, the endpoint is an email address
\item For the \code{sms} protocol, the endpoint is a phone number of an
SMS-enabled device
\item For the \code{sqs} protocol, the endpoint is the ARN of an Amazon SQS
queue
\item For the \code{application} protocol, the endpoint is the EndpointArn of a
mobile app and device.
\item For the \code{lambda} protocol, the endpoint is the ARN of an Amazon
Lambda function.
}}

\item{Attributes}{A map of attributes with their corresponding values.

The following lists the names, descriptions, and values of the special
request parameters that the \code{SetTopicAttributes} action uses:
\itemize{
\item \code{DeliveryPolicy} -- The policy that defines how Amazon SNS retries
failed deliveries to HTTP/S endpoints.
\item \code{FilterPolicy} -- The simple JSON object that lets your subscriber
receive only a subset of messages, rather than receiving every
message published to the topic.
\item \code{RawMessageDelivery} -- When set to \code{true}, enables raw message
delivery to Amazon SQS or HTTP/S endpoints. This eliminates the need
for the endpoints to process JSON formatting, which is otherwise
created for Amazon SNS metadata.
\item \code{RedrivePolicy} -- When specified, sends undeliverable messages to
the specified Amazon SQS dead-letter queue. Messages that can\'t be
delivered due to client errors (for example, when the subscribed
endpoint is unreachable) or server errors (for example, when the
service that powers the subscribed endpoint becomes unavailable) are
held in the dead-letter queue for further analysis or reprocessing.
}}

\item{ReturnSubscriptionArn}{Sets whether the response from the \code{Subscribe} request includes the
subscription ARN, even if the subscription is not yet confirmed.
\itemize{
\item If you have the subscription ARN returned, the response includes the
ARN in all cases, even if the subscription is not yet confirmed.
\item If you don\'t have the subscription ARN returned, in addition to the
ARN for confirmed subscriptions, the response also includes the
\verb{pending subscription} ARN value for subscriptions that aren\'t yet
confirmed. A subscription becomes confirmed when the subscriber
calls the \code{ConfirmSubscription} action with a confirmation token.
}

If you set this parameter to \code{true}, .

The default value is \code{false}.}
}
\description{
Prepares to subscribe an endpoint by sending the endpoint a confirmation
message. To actually create a subscription, the endpoint owner must call
the \code{ConfirmSubscription} action with the token from the confirmation
message. Confirmation tokens are valid for three days.
}
\details{
This action is throttled at 100 transactions per second (TPS).
}
\section{Request syntax}{
\preformatted{svc$subscribe(
  TopicArn = "string",
  Protocol = "string",
  Endpoint = "string",
  Attributes = list(
    "string"
  ),
  ReturnSubscriptionArn = TRUE|FALSE
)
}
}

\keyword{internal}
