% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridge_operations.R
\name{eventbridge_create_endpoint}
\alias{eventbridge_create_endpoint}
\title{Creates a global endpoint}
\usage{
eventbridge_create_endpoint(
  Name,
  Description = NULL,
  RoutingConfig,
  ReplicationConfig = NULL,
  EventBuses,
  RoleArn = NULL
)
}
\arguments{
\item{Name}{[required] The name of the global endpoint. For example,
\code{"Name":"us-east-2-custom_bus_A-endpoint"}.}

\item{Description}{A description of the global endpoint.}

\item{RoutingConfig}{[required] Configure the routing policy, including the health check and secondary
Region..}

\item{ReplicationConfig}{Enable or disable event replication.}

\item{EventBuses}{[required] Define the event buses used.

The names of the event buses must be identical in each Region.}

\item{RoleArn}{The ARN of the role used for replication.}
}
\description{
Creates a global endpoint. Global endpoints improve your application's availability by making it regional-fault tolerant. To do this, you define a primary and secondary Region with event buses in each Region. You also create a Amazon Route 53 health check that will tell EventBridge to route events to the secondary Region when an "unhealthy" state is encountered and events will be routed back to the primary Region when the health check reports a "healthy" state.

See \url{https://paws-r.github.io/docs/eventbridge/create_endpoint.html} for full documentation.
}
\keyword{internal}
