% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridge_operations.R
\name{eventbridge_put_permission}
\alias{eventbridge_put_permission}
\title{Running PutPermission permits the specified Amazon Web Services account
or Amazon Web Services organization to put events to the specified event
bus}
\usage{
eventbridge_put_permission(
  EventBusName = NULL,
  Action = NULL,
  Principal = NULL,
  StatementId = NULL,
  Condition = NULL,
  Policy = NULL
)
}
\arguments{
\item{EventBusName}{The name of the event bus associated with the rule. If you omit this,
the default event bus is used.}

\item{Action}{The action that you are enabling the other account to perform.}

\item{Principal}{The 12-digit Amazon Web Services account ID that you are permitting to
put events to your default event bus. Specify "*" to permit any account
to put events to your default event bus.

If you specify "*" without specifying \code{Condition}, avoid creating rules
that may match undesirable events. To create more secure rules, make
sure that the event pattern for each rule contains an \code{account} field
with a specific account ID from which to receive events. Rules with an
account field do not match any events sent from other accounts.}

\item{StatementId}{An identifier string for the external account that you are granting
permissions to. If you later want to revoke the permission for this
external account, specify this \code{StatementId} when you run
\code{\link[=eventbridge_remove_permission]{remove_permission}}.

Each \code{StatementId} must be unique.}

\item{Condition}{This parameter enables you to limit the permission to accounts that
fulfill a certain condition, such as being a member of a certain Amazon
Web Services organization. For more information about Amazon Web
Services Organizations, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html}{What Is Amazon Web Services Organizations}
in the \emph{Amazon Web Services Organizations User Guide}.

If you specify \code{Condition} with an Amazon Web Services organization ID,
and specify "*" as the value for \code{Principal}, you grant permission to
all the accounts in the named organization.

The \code{Condition} is a JSON string which must contain \code{Type}, \code{Key}, and
\code{Value} fields.}

\item{Policy}{A JSON string that describes the permission policy statement. You can
include a \code{Policy} parameter in the request instead of using the
\code{StatementId}, \code{Action}, \code{Principal}, or \code{Condition} parameters.}
}
\description{
Running \code{\link[=eventbridge_put_permission]{put_permission}} permits the specified Amazon Web Services account or Amazon Web Services organization to put events to the specified \emph{event bus}. Amazon EventBridge (CloudWatch Events) rules in your account are triggered by these events arriving to an event bus in your account.

See \url{https://paws-r.github.io/docs/eventbridge/put_permission.html} for full documentation.
}
\keyword{internal}
