% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mq_operations.R
\name{mq_create_configuration}
\alias{mq_create_configuration}
\title{Creates a new configuration for the specified configuration name}
\usage{
mq_create_configuration(
  AuthenticationStrategy = NULL,
  EngineType,
  EngineVersion,
  Name,
  Tags = NULL
)
}
\arguments{
\item{AuthenticationStrategy}{Optional. The authentication strategy associated with the configuration.
The default is SIMPLE.}

\item{EngineType}{[required] Required. The type of broker engine. Currently, Amazon MQ supports
ACTIVEMQ and RABBITMQ.}

\item{EngineVersion}{[required] Required. The broker engine's version. For a list of supported engine
versions, see \href{https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/}{Supported engines}.}

\item{Name}{[required] Required. The name of the configuration. This value can contain only
alphanumeric characters, dashes, periods, underscores, and tildes (- .
_ ~). This value must be 1-150 characters long.}

\item{Tags}{Create tags when creating the configuration.}
}
\description{
Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the engine type and version).

See \url{https://paws-r.github.io/docs/mq/create_configuration.html} for full documentation.
}
\keyword{internal}
