% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_list_queues}
\alias{sqs_list_queues}
\title{Returns a list of your queues in the current region}
\usage{
sqs_list_queues(QueueNamePrefix = NULL, NextToken = NULL, MaxResults = NULL)
}
\arguments{
\item{QueueNamePrefix}{A string to use for filtering the list results. Only those queues whose
name begins with the specified string are returned.

Queue URLs and names are case-sensitive.}

\item{NextToken}{Pagination token to request the next set of results.}

\item{MaxResults}{Maximum number of results to include in the response. Value range is 1
to 1000. You must set \code{MaxResults} to receive a value for \code{NextToken} in
the response.}
}
\description{
Returns a list of your queues in the current region. The response includes a maximum of 1,000 results. If you specify a value for the optional \code{QueueNamePrefix} parameter, only queues with a name that begins with the specified value are returned.

See \url{https://paws-r.github.io/docs/sqs/list_queues.html} for full documentation.
}
\keyword{internal}
