% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_respond_decision_task_completed}
\alias{swf_respond_decision_task_completed}
\title{Used by deciders to tell the service that the DecisionTask identified by
the taskToken has successfully completed}
\usage{
swf_respond_decision_task_completed(
  taskToken,
  decisions = NULL,
  executionContext = NULL
)
}
\arguments{
\item{taskToken}{[required] The \code{taskToken} from the DecisionTask.

\code{taskToken} is generated by the service and should be treated as an
opaque value. If the task is passed to another process, its \code{taskToken}
must also be passed. This enables it to provide its progress and respond
with results.}

\item{decisions}{The list of decisions (possibly empty) made by the decider while
processing this decision task. See the docs for the Decision structure
for details.}

\item{executionContext}{User defined context to add to workflow execution.}
}
\description{
Used by deciders to tell the service that the DecisionTask identified by the \code{taskToken} has successfully completed. The \code{decisions} argument specifies the list of decisions made while processing the task.

See \url{https://paws-r.github.io/docs/swf/respond_decision_task_completed.html} for full documentation.
}
\keyword{internal}
