% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationservice_operations.R
\name{locationservice_create_tracker}
\alias{locationservice_create_tracker}
\title{Creates a tracker resource in your Amazon Web Services account, which
lets you retrieve current and historical location of devices}
\usage{
locationservice_create_tracker(
  Description = NULL,
  KmsKeyId = NULL,
  PositionFiltering = NULL,
  PricingPlan = NULL,
  PricingPlanDataSource = NULL,
  Tags = NULL,
  TrackerName
)
}
\arguments{
\item{Description}{An optional description for the tracker resource.}

\item{KmsKeyId}{A key identifier for an \href{https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html}{Amazon Web Services KMS customer managed key}.
Enter a key ID, key ARN, alias name, or alias ARN.}

\item{PositionFiltering}{Specifies the position filtering for the tracker resource.

Valid values:
\itemize{
\item \code{TimeBased} - Location updates are evaluated against linked geofence
collections, but not every location update is stored. If your update
frequency is more often than 30 seconds, only one update per 30
seconds is stored for each unique device ID.
\item \code{DistanceBased} - If the device has moved less than 30 m (98.4 ft),
location updates are ignored. Location updates within this area are
neither evaluated against linked geofence collections, nor stored.
This helps control costs by reducing the number of geofence
evaluations and historical device positions to paginate through.
Distance-based filtering can also reduce the effects of GPS noise
when displaying device trajectories on a map.
\item \code{AccuracyBased} - If the device has moved less than the measured
accuracy, location updates are ignored. For example, if two
consecutive updates from a device have a horizontal accuracy of 5 m
and 10 m, the second update is ignored if the device has moved less
than 15 m. Ignored location updates are neither evaluated against
linked geofence collections, nor stored. This can reduce the effects
of GPS noise when displaying device trajectories on a map, and can
help control your costs by reducing the number of geofence
evaluations.
}

This field is optional. If not specified, the default value is
\code{TimeBased}.}

\item{PricingPlan}{No longer used. If included, the only allowed value is
\code{RequestBasedUsage}.}

\item{PricingPlanDataSource}{This parameter is no longer used.}

\item{Tags}{Applies one or more tags to the tracker resource. A tag is a key-value
pair helps manage, identify, search, and filter your resources by
labelling them.

Format: \code{"key" : "value"}

Restrictions:
\itemize{
\item Maximum 50 tags per resource
\item Each resource tag must be unique with a maximum of one value.
\item Maximum key length: 128 Unicode characters in UTF-8
\item Maximum value length: 256 Unicode characters in UTF-8
\item Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
characters: + - = . _ : / @.
\item Cannot use "aws:" as a prefix for a key.
}}

\item{TrackerName}{[required] The name for the tracker resource.

Requirements:
\itemize{
\item Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-),
periods (.), and underscores (_).
\item Must be a unique tracker resource name.
\item No spaces allowed. For example, \code{ExampleTracker}.
}}
}
\description{
Creates a tracker resource in your Amazon Web Services account, which lets you retrieve current and historical location of devices.

See \url{https://www.paws-r-sdk.com/docs/locationservice_create_tracker/} for full documentation.
}
\keyword{internal}
