% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mwaa_service.R
\name{mwaa}
\alias{mwaa}
\title{AmazonMWAA}
\usage{
mwaa(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Managed Workflows for Apache Airflow

This section contains the Amazon Managed Workflows for Apache Airflow
(MWAA) API reference documentation. For more information, see \href{https://docs.aws.amazon.com/mwaa/latest/userguide/what-is-mwaa.html}{What is Amazon MWAA?}.

\strong{Endpoints}
\itemize{
\item \verb{api.airflow.\{region\}.amazonaws.com} - This endpoint is used for
environment management.
\itemize{
\item \code{\link[=mwaa_create_environment]{create_environment}}
\item \code{\link[=mwaa_delete_environment]{delete_environment}}
\item \code{\link[=mwaa_get_environment]{get_environment}}
\item \code{\link[=mwaa_list_environments]{list_environments}}
\item \code{\link[=mwaa_list_tags_for_resource]{list_tags_for_resource}}
\item \code{\link[=mwaa_tag_resource]{tag_resource}}
\item \code{\link[=mwaa_untag_resource]{untag_resource}}
\item \code{\link[=mwaa_update_environment]{update_environment}}
}
\item \verb{env.airflow.\{region\}.amazonaws.com} - This endpoint is used to
operate the Airflow environment.
\itemize{
\item \code{\link[=mwaa_create_cli_token]{create_cli_token}}
\item \code{\link[=mwaa_create_web_login_token]{create_web_login_token}}
}
\item \verb{ops.airflow.\{region\}.amazonaws.com} - This endpoint is used to push
environment metrics that track environment health.
\itemize{
\item \code{\link[=mwaa_publish_metrics]{publish_metrics}}
}
}

\strong{Regions}

For a list of regions that Amazon MWAA supports, see \href{https://docs.aws.amazon.com/mwaa/latest/userguide/what-is-mwaa.html#regions-mwaa}{Region availability}
in the \emph{Amazon MWAA User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- mwaa(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=mwaa_create_cli_token]{create_cli_token} \tab Creates a CLI token for the Airflow CLI\cr
\link[=mwaa_create_environment]{create_environment} \tab Creates an Amazon Managed Workflows for Apache Airflow (MWAA) environment\cr
\link[=mwaa_create_web_login_token]{create_web_login_token} \tab Creates a web login token for the Airflow Web UI\cr
\link[=mwaa_delete_environment]{delete_environment} \tab Deletes an Amazon Managed Workflows for Apache Airflow (MWAA) environment\cr
\link[=mwaa_get_environment]{get_environment} \tab Describes an Amazon Managed Workflows for Apache Airflow (MWAA) environment\cr
\link[=mwaa_list_environments]{list_environments} \tab Lists the Amazon Managed Workflows for Apache Airflow (MWAA) environments\cr
\link[=mwaa_list_tags_for_resource]{list_tags_for_resource} \tab Lists the key-value tag pairs associated to the Amazon Managed Workflows for Apache Airflow (MWAA) environment\cr
\link[=mwaa_publish_metrics]{publish_metrics} \tab Internal only\cr
\link[=mwaa_tag_resource]{tag_resource} \tab Associates key-value tag pairs to your Amazon Managed Workflows for Apache Airflow (MWAA) environment\cr
\link[=mwaa_untag_resource]{untag_resource} \tab Removes key-value tag pairs associated to your Amazon Managed Workflows for Apache Airflow (MWAA) environment\cr
\link[=mwaa_update_environment]{update_environment} \tab Updates an Amazon Managed Workflows for Apache Airflow (MWAA) environment
}
}

\examples{
\dontrun{
svc <- mwaa()
svc$create_cli_token(
  Foo = 123
)
}

}
