% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridgepipes_operations.R
\name{eventbridgepipes_update_pipe}
\alias{eventbridgepipes_update_pipe}
\title{Update an existing pipe}
\usage{
eventbridgepipes_update_pipe(
  Description = NULL,
  DesiredState = NULL,
  Enrichment = NULL,
  EnrichmentParameters = NULL,
  LogConfiguration = NULL,
  Name,
  RoleArn,
  SourceParameters = NULL,
  Target = NULL,
  TargetParameters = NULL
)
}
\arguments{
\item{Description}{A description of the pipe.}

\item{DesiredState}{The state the pipe should be in.}

\item{Enrichment}{The ARN of the enrichment resource.}

\item{EnrichmentParameters}{The parameters required to set up enrichment on your pipe.}

\item{LogConfiguration}{The logging configuration settings for the pipe.}

\item{Name}{[required] The name of the pipe.}

\item{RoleArn}{[required] The ARN of the role that allows the pipe to send data to the target.}

\item{SourceParameters}{The parameters required to set up a source for your pipe.}

\item{Target}{The ARN of the target resource.}

\item{TargetParameters}{The parameters required to set up a target for your pipe.

For more information about pipe target parameters, including how to use
dynamic path parameters, see \href{https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html}{Target parameters}
in the \emph{Amazon EventBridge User Guide}.}
}
\description{
Update an existing pipe. When you call \code{\link[=eventbridgepipes_update_pipe]{update_pipe}}, EventBridge only the updates fields you have specified in the request; the rest remain unchanged. The exception to this is if you modify any Amazon Web Services-service specific fields in the \code{SourceParameters}, \code{EnrichmentParameters}, or \code{TargetParameters} objects. For example, \code{DynamoDBStreamParameters} or \code{EventBridgeEventBusParameters}. EventBridge updates the fields in these objects atomically as one and overrides existing values. This is by design, and means that if you don't specify an optional field in one of these \code{Parameters} objects, EventBridge sets that field to its system-default value during the update.

See \url{https://www.paws-r-sdk.com/docs/eventbridgepipes_update_pipe/} for full documentation.
}
\keyword{internal}
