% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridge_operations.R
\name{eventbridge_list_rule_names_by_target}
\alias{eventbridge_list_rule_names_by_target}
\title{Lists the rules for the specified target}
\usage{
eventbridge_list_rule_names_by_target(
  TargetArn,
  EventBusName = NULL,
  NextToken = NULL,
  Limit = NULL
)
}
\arguments{
\item{TargetArn}{[required] The Amazon Resource Name (ARN) of the target resource.}

\item{EventBusName}{The name or ARN of the event bus to list rules for. If you omit this,
the default event bus is used.}

\item{NextToken}{The token returned by a previous call, which you can use to retrieve the
next set of results.

The value of \code{nextToken} is a unique pagination token for each page. To
retrieve the next page of results, make the call again using the
returned token. Keep all other arguments unchanged.

Using an expired pagination token results in an \verb{HTTP 400 InvalidToken}
error.}

\item{Limit}{The maximum number of results to return.}
}
\description{
Lists the rules for the specified target. You can see which of the rules in Amazon EventBridge can invoke a specific target in your account.

See \url{https://www.paws-r-sdk.com/docs/eventbridge_list_rule_names_by_target/} for full documentation.
}
\keyword{internal}
