% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourceexplorer_operations.R
\name{resourceexplorer_list_managed_views}
\alias{resourceexplorer_list_managed_views}
\title{Lists the Amazon resource names (ARNs) of the Amazon Web
Services-managed views available in the Amazon Web Services Region in
which you call this operation}
\usage{
resourceexplorer_list_managed_views(
  MaxResults = NULL,
  NextToken = NULL,
  ServicePrincipal = NULL
)
}
\arguments{
\item{MaxResults}{The maximum number of results that you want included on each page of the
response. If you do not include this parameter, it defaults to a value
appropriate to the operation. If additional items exist beyond those
included in the current response, the \code{NextToken} response element is
present and has a value (is not null). Include that value as the
\code{NextToken} request parameter in the next call to the operation to get
the next part of the results.

An API operation can return fewer results than the maximum even when
there are more results available. You should check \code{NextToken} after
every operation to ensure that you receive all of the results.}

\item{NextToken}{The parameter for receiving additional results if you receive a
\code{NextToken} response in a previous request. A \code{NextToken} response
indicates that more output is available. Set this parameter to the value
of the previous call's \code{NextToken} response to indicate where the output
should continue from. The pagination tokens expire after 24 hours.}

\item{ServicePrincipal}{Specifies a service principal name. If specified, then the operation
only returns the managed views that are managed by the input service.}
}
\description{
Lists the Amazon resource names (ARNs) of the \href{https://docs.aws.amazon.com/resource-explorer/latest/userguide/aws-managed-views.html}{Amazon Web Services-managed views} available in the Amazon Web Services Region in which you call this operation.

See \url{https://www.paws-r-sdk.com/docs/resourceexplorer_list_managed_views/} for full documentation.
}
\keyword{internal}
