% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_stop_task}
\alias{ecs_stop_task}
\title{Stops a running task}
\usage{
ecs_stop_task(cluster, task, reason)
}
\arguments{
\item{cluster}{The short name or full Amazon Resource Name (ARN) of the cluster that
hosts the task to stop. If you do not specify a cluster, the default
cluster is assumed.}

\item{task}{[required] The task ID or full Amazon Resource Name (ARN) of the task to stop.}

\item{reason}{An optional message specified when a task is stopped. For example, if
you are using a custom scheduler, you can use this parameter to specify
the reason for stopping the task here, and the message appears in
subsequent DescribeTasks API operations on this task. Up to 255
characters are allowed in this message.}
}
\description{
Stops a running task. Any tags associated with the task will be deleted.
}
\details{
When StopTask is called on a task, the equivalent of \code{docker stop} is
issued to the containers running in the task. This results in a
\code{SIGTERM} value and a default 30-second timeout, after which the
\code{SIGKILL} value is sent and the containers are forcibly stopped. If the
container handles the \code{SIGTERM} value gracefully and exits within 30
seconds from receiving it, no \code{SIGKILL} value is sent.

The default 30-second timeout can be configured on the Amazon ECS
container agent with the \code{ECS_CONTAINER_STOP_TIMEOUT} variable. For more
information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html}{Amazon ECS Container Agent Configuration}
in the \emph{Amazon Elastic Container Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$stop_task(
  cluster = "string",
  task = "string",
  reason = "string"
)
}
}

\keyword{internal}
