% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_describe_environment_health}
\alias{elasticbeanstalk_describe_environment_health}
\title{Returns information about the overall health of the specified
environment}
\usage{
elasticbeanstalk_describe_environment_health(EnvironmentName,
  EnvironmentId, AttributeNames)
}
\arguments{
\item{EnvironmentName}{Specify the environment by name.

You must specify either this or an EnvironmentName, or both.}

\item{EnvironmentId}{Specify the environment by ID.

You must specify either this or an EnvironmentName, or both.}

\item{AttributeNames}{Specify the response elements to return. To retrieve all attributes, set
to \code{All}. If no attribute names are specified, returns the name of the
environment.}
}
\description{
Returns information about the overall health of the specified
environment. The \strong{DescribeEnvironmentHealth} operation is only
available with AWS Elastic Beanstalk Enhanced Health.
}
\section{Request syntax}{
\preformatted{svc$describe_environment_health(
  EnvironmentName = "string",
  EnvironmentId = "string",
  AttributeNames = list(
    "Status"|"Color"|"Causes"|"ApplicationMetrics"|"InstancesHealth"|"All"|"HealthStatus"|"RefreshedAt"
  )
)
}
}

\examples{
# The following operation retrieves overall health information for an
# environment named my-env:
\donttest{svc$describe_environment_health(
  AttributeNames = list(
    "All"
  ),
  EnvironmentName = "my-env"
)}

}
\keyword{internal}
