% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_fleets}
\alias{ec2_describe_fleets}
\title{Describes the specified EC2 Fleets or all of your EC2 Fleets}
\usage{
ec2_describe_fleets(DryRun, MaxResults, NextToken, FleetIds, Filters)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{MaxResults}{The maximum number of results to return in a single call. Specify a
value between 1 and 1000. The default value is 1000. To retrieve the
remaining results, make another call with the returned \code{NextToken}
value.}

\item{NextToken}{The token for the next set of results.}

\item{FleetIds}{The ID of the EC2 Fleets.}

\item{Filters}{The filters.
\itemize{
\item \code{activity-status} - The progress of the EC2 Fleet ( \code{error} |
\code{pending-fulfillment} | \code{pending-termination} | \code{fulfilled}).
\item \code{excess-capacity-termination-policy} - Indicates whether to
terminate running instances if the target capacity is decreased
below the current EC2 Fleet size (\code{true} | \code{false}).
\item \code{fleet-state} - The state of the EC2 Fleet (\code{submitted} | \code{active} |
\code{deleted} | \code{failed} | \code{deleted-running} | \code{deleted-terminating} |
\code{modifying}).
\item \code{replace-unhealthy-instances} - Indicates whether EC2 Fleet should
replace unhealthy instances (\code{true} | \code{false}).
\item \code{type} - The type of request (\code{instant} | \code{request} | \code{maintain}).
}}
}
\description{
Describes the specified EC2 Fleets or all of your EC2 Fleets.
}
\section{Request syntax}{
\preformatted{svc$describe_fleets(
  DryRun = TRUE|FALSE,
  MaxResults = 123,
  NextToken = "string",
  FleetIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
