% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_describe_task_definition}
\alias{ecs_describe_task_definition}
\title{Describes a task definition}
\usage{
ecs_describe_task_definition(taskDefinition, include)
}
\arguments{
\item{taskDefinition}{[required] The \code{family} for the latest \code{ACTIVE} revision, \code{family} and \code{revision}
(\code{family:revision}) for a specific revision in the family, or full
Amazon Resource Name (ARN) of the task definition to describe.}

\item{include}{Specifies whether to see the resource tags for the task definition. If
\code{TAGS} is specified, the tags are included in the response. If this
field is omitted, tags are not included in the response.}
}
\description{
Describes a task definition. You can specify a \code{family} and \code{revision}
to find information about a specific task definition, or you can simply
specify the family to find the latest \code{ACTIVE} revision in that family.

You can only describe \code{INACTIVE} task definitions while an active task
or service references them.
}
\section{Request syntax}{
\preformatted{svc$describe_task_definition(
  taskDefinition = "string",
  include = list(
    "TAGS"
  )
)
}
}

\examples{
\dontrun{
# This example provides a description of the specified task definition.
svc$describe_task_definition(
  taskDefinition = "hello_world:8"
)
}

}
\keyword{internal}
