% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_delete_disk}
\alias{lightsail_delete_disk}
\title{Deletes the specified block storage disk}
\usage{
lightsail_delete_disk(diskName, forceDeleteAddOns)
}
\arguments{
\item{diskName}{[required] The unique name of the disk you want to delete (e.g., \code{my-disk}).}

\item{forceDeleteAddOns}{A Boolean value to indicate whether to delete the enabled add-ons for
the disk.}
}
\description{
Deletes the specified block storage disk. The disk must be in the
\code{available} state (not attached to a Lightsail instance).

The disk may remain in the \code{deleting} state for several minutes.

The \verb{delete disk} operation supports tag-based access control via
resource tags applied to the resource identified by \verb{disk name}. For
more information, see the Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$delete_disk(
  diskName = "string",
  forceDeleteAddOns = TRUE|FALSE
)
}
}

\keyword{internal}
