% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_update_distribution}
\alias{lightsail_update_distribution}
\title{Updates an existing Amazon Lightsail content delivery network (CDN)
distribution}
\usage{
lightsail_update_distribution(distributionName, origin,
  defaultCacheBehavior, cacheBehaviorSettings, cacheBehaviors, isEnabled)
}
\arguments{
\item{distributionName}{[required] The name of the distribution to update.

Use the \code{GetDistributions} action to get a list of distribution names
that you can specify.}

\item{origin}{An object that describes the origin resource for the distribution, such
as a Lightsail instance or load balancer.

The distribution pulls, caches, and serves content from the origin.}

\item{defaultCacheBehavior}{An object that describes the default cache behavior for the
distribution.}

\item{cacheBehaviorSettings}{An object that describes the cache behavior settings for the
distribution.

The \code{cacheBehaviorSettings} specified in your
\code{UpdateDistributionRequest} will replace your distribution's existing
settings.}

\item{cacheBehaviors}{An array of objects that describe the per-path cache behavior for the
distribution.}

\item{isEnabled}{Indicates whether to enable the distribution.}
}
\description{
Updates an existing Amazon Lightsail content delivery network (CDN)
distribution.

Use this action to update the configuration of your existing
distribution
}
\section{Request syntax}{
\preformatted{svc$update_distribution(
  distributionName = "string",
  origin = list(
    name = "string",
    regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2",
    protocolPolicy = "http-only"|"https-only"
  ),
  defaultCacheBehavior = list(
    behavior = "dont-cache"|"cache"
  ),
  cacheBehaviorSettings = list(
    defaultTTL = 123,
    minimumTTL = 123,
    maximumTTL = 123,
    allowedHTTPMethods = "string",
    cachedHTTPMethods = "string",
    forwardedCookies = list(
      option = "none"|"allow-list"|"all",
      cookiesAllowList = list(
        "string"
      )
    ),
    forwardedHeaders = list(
      option = "none"|"allow-list"|"all",
      headersAllowList = list(
        "Accept"|"Accept-Charset"|"Accept-Datetime"|"Accept-Encoding"|"Accept-Language"|"Authorization"|"CloudFront-Forwarded-Proto"|"CloudFront-Is-Desktop-Viewer"|"CloudFront-Is-Mobile-Viewer"|"CloudFront-Is-SmartTV-Viewer"|"CloudFront-Is-Tablet-Viewer"|"CloudFront-Viewer-Country"|"Host"|"Origin"|"Referer"
      )
    ),
    forwardedQueryStrings = list(
      option = TRUE|FALSE,
      queryStringsAllowList = list(
        "string"
      )
    )
  ),
  cacheBehaviors = list(
    list(
      path = "string",
      behavior = "dont-cache"|"cache"
    )
  ),
  isEnabled = TRUE|FALSE
)
}
}

\keyword{internal}
