% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_customer_gateways}
\alias{ec2_describe_customer_gateways}
\title{Describes one or more of your VPN customer gateways}
\usage{
ec2_describe_customer_gateways(CustomerGatewayIds, Filters, DryRun)
}
\arguments{
\item{CustomerGatewayIds}{One or more customer gateway IDs.

Default: Describes all your customer gateways.}

\item{Filters}{One or more filters.
\itemize{
\item \code{bgp-asn} - The customer gateway's Border Gateway Protocol (BGP)
Autonomous System Number (ASN).
\item \code{customer-gateway-id} - The ID of the customer gateway.
\item \code{ip-address} - The IP address of the customer gateway's
Internet-routable external interface.
\item \code{state} - The state of the customer gateway (\code{pending} | \code{available}
| \code{deleting} | \code{deleted}).
\item \code{type} - The type of customer gateway. Currently, the only supported
type is \code{ipsec.1}.
\item \code{tag}:<key> - The key/value combination of a tag assigned to
the resource. Use the tag key in the filter name and the tag value
as the filter value. For example, to find all resources that have a
tag with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner}
for the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  CustomerGateways = list(
    list(
      BgpAsn = "string",
      CustomerGatewayId = "string",
      IpAddress = "string",
      CertificateArn = "string",
      State = "string",
      Type = "string",
      DeviceName = "string",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}
\description{
Describes one or more of your VPN customer gateways.

For more information, see \href{https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html}{AWS Site-to-Site VPN} in the
\emph{AWS Site-to-Site VPN User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_customer_gateways(
  CustomerGatewayIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  DryRun = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example describes the specified customer gateway.
svc$describe_customer_gateways(
  CustomerGatewayIds = list(
    "cgw-0e11f167"
  )
)
}

}
\keyword{internal}
