% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_describe_environment_managed_action_history}
\alias{elasticbeanstalk_describe_environment_managed_action_history}
\title{Lists an environment's completed and failed managed actions}
\usage{
elasticbeanstalk_describe_environment_managed_action_history(
  EnvironmentId, EnvironmentName, NextToken, MaxItems)
}
\arguments{
\item{EnvironmentId}{The environment ID of the target environment.}

\item{EnvironmentName}{The name of the target environment.}

\item{NextToken}{The pagination token returned by a previous request.}

\item{MaxItems}{The maximum number of items to return for a single request.}
}
\value{
A list with the following syntax:\preformatted{list(
  ManagedActionHistoryItems = list(
    list(
      ActionId = "string",
      ActionType = "InstanceRefresh"|"PlatformUpdate"|"Unknown",
      ActionDescription = "string",
      FailureType = "UpdateCancelled"|"CancellationFailed"|"RollbackFailed"|"RollbackSuccessful"|"InternalFailure"|"InvalidEnvironmentState"|"PermissionsError",
      Status = "Completed"|"Failed"|"Unknown",
      FailureDescription = "string",
      ExecutedTime = as.POSIXct(
        "2015-01-01"
      ),
      FinishedTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists an environment's completed and failed managed actions.
}
\section{Request syntax}{
\preformatted{svc$describe_environment_managed_action_history(
  EnvironmentId = "string",
  EnvironmentName = "string",
  NextToken = "string",
  MaxItems = 123
)
}
}

\keyword{internal}
