% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_enable_volume_io}
\alias{ec2_enable_volume_io}
\title{Enables I/O operations for a volume that had I/O operations disabled
because the data on the volume was potentially inconsistent}
\usage{
ec2_enable_volume_io(DryRun, VolumeId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VolumeId}{[required] The ID of the volume.}
}
\value{
An empty list.
}
\description{
Enables I/O operations for a volume that had I/O operations disabled
because the data on the volume was potentially inconsistent.
}
\section{Request syntax}{
\preformatted{svc$enable_volume_io(
  DryRun = TRUE|FALSE,
  VolumeId = "string"
)
}
}

\examples{
\dontrun{
# This example enables I/O on volume `vol-1234567890abcdef0`.
svc$enable_volume_io(
  VolumeId = "vol-1234567890abcdef0"
)
}

}
\keyword{internal}
