% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_vpc}
\alias{ec2_create_vpc}
\title{Creates a VPC with the specified IPv4 CIDR block}
\usage{
ec2_create_vpc(CidrBlock, AmazonProvidedIpv6CidrBlock, DryRun,
  InstanceTenancy)
}
\arguments{
\item{CidrBlock}{[required] The IPv4 network range for the VPC, in CIDR notation. For example,
\code{10.0.0.0/16}.}

\item{AmazonProvidedIpv6CidrBlock}{Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for
the VPC. You cannot specify the range of IP addresses, or the size of
the CIDR block.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceTenancy}{The tenancy options for instances launched into the VPC. For \code{default},
instances are launched with shared tenancy by default. You can launch
instances with any tenancy into a shared tenancy VPC. For \code{dedicated},
instances are launched as dedicated tenancy instances by default. You
can only launch instances with a tenancy of \code{dedicated} or \code{host} into a
dedicated tenancy VPC.

\strong{Important:} The \code{host} value cannot be used with this parameter. Use
the \code{default} or \code{dedicated} values only.

Default: \code{default}}
}
\description{
Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you
can create uses a /28 netmask (16 IPv4 addresses), and the largest uses
a /16 netmask (65,536 IPv4 addresses). For more information about how
large to make your VPC, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html}{Your VPC and Subnets}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}
\details{
You can optionally request an Amazon-provided IPv6 CIDR block for the
VPC. The IPv6 CIDR block uses a /56 prefix length, and is allocated from
Amazon's pool of IPv6 addresses. You cannot choose the IPv6 range for
your VPC.

By default, each instance you launch in the VPC has the default DHCP
options, which include only a default DNS server that we provide
(AmazonProvidedDNS). For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html}{DHCP Options Sets}
in the \emph{Amazon Virtual Private Cloud User Guide}.

You can specify the instance tenancy value for the VPC when you create
it. You can't change this value for the VPC after you create it. For
more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html}{Dedicated Instances}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_vpc(
  CidrBlock = "string",
  AmazonProvidedIpv6CidrBlock = TRUE|FALSE,
  DryRun = TRUE|FALSE,
  InstanceTenancy = "default"|"dedicated"|"host"
)
}
}

\examples{
# This example creates a VPC with the specified CIDR block.
\donttest{svc$create_vpc(
  CidrBlock = "10.0.0.0/16"
)}

}
\keyword{internal}
