% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_replace_route}
\alias{ec2_replace_route}
\title{Replaces an existing route within a route table in a VPC}
\usage{
ec2_replace_route(DestinationCidrBlock, DestinationIpv6CidrBlock,
  DryRun, EgressOnlyInternetGatewayId, GatewayId, InstanceId,
  NatGatewayId, TransitGatewayId, NetworkInterfaceId, RouteTableId,
  VpcPeeringConnectionId)
}
\arguments{
\item{DestinationCidrBlock}{The IPv4 CIDR address block used for the destination match. The value
that you provide must match the CIDR of an existing route in the table.}

\item{DestinationIpv6CidrBlock}{The IPv6 CIDR address block used for the destination match. The value
that you provide must match the CIDR of an existing route in the table.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{EgressOnlyInternetGatewayId}{[IPv6 traffic only] The ID of an egress-only internet gateway.}

\item{GatewayId}{The ID of an internet gateway or virtual private gateway.}

\item{InstanceId}{The ID of a NAT instance in your VPC.}

\item{NatGatewayId}{[IPv4 traffic only] The ID of a NAT gateway.}

\item{TransitGatewayId}{The ID of a transit gateway.}

\item{NetworkInterfaceId}{The ID of a network interface.}

\item{RouteTableId}{[required] The ID of the route table.}

\item{VpcPeeringConnectionId}{The ID of a VPC peering connection.}
}
\description{
Replaces an existing route within a route table in a VPC. You must
provide only one of the following: internet gateway or virtual private
gateway, NAT instance, NAT gateway, VPC peering connection, network
interface, or egress-only internet gateway.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html}{Route Tables}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$replace_route(
  DestinationCidrBlock = "string",
  DestinationIpv6CidrBlock = "string",
  DryRun = TRUE|FALSE,
  EgressOnlyInternetGatewayId = "string",
  GatewayId = "string",
  InstanceId = "string",
  NatGatewayId = "string",
  TransitGatewayId = "string",
  NetworkInterfaceId = "string",
  RouteTableId = "string",
  VpcPeeringConnectionId = "string"
)
}
}

\examples{
# This example replaces the specified route in the specified table table.
# The new route matches the specified CIDR and sends the traffic to the
# specified virtual private gateway.
\donttest{svc$replace_route(
  DestinationCidrBlock = "10.0.0.0/16",
  GatewayId = "vgw-9a4cacf3",
  RouteTableId = "rtb-22574640"
)}

}
\keyword{internal}
