% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_enable_add_on}
\alias{lightsail_enable_add_on}
\title{Enables or modifies an add-on for an Amazon Lightsail resource}
\usage{
lightsail_enable_add_on(resourceName, addOnRequest)
}
\arguments{
\item{resourceName}{[required] The name of the source resource for which to enable or modify the
add-on.}

\item{addOnRequest}{[required] An array of strings representing the add-on to enable or modify.}
}
\description{
Enables or modifies an add-on for an Amazon Lightsail resource. For more
information, see the \href{https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots}{Lightsail Dev Guide}.
}
\section{Request syntax}{
\preformatted{svc$enable_add_on(
  resourceName = "string",
  addOnRequest = list(
    addOnType = "AutoSnapshot",
    autoSnapshotAddOnRequest = list(
      snapshotTimeOfDay = "string"
    )
  )
)
}
}

\keyword{internal}
