% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_replace_network_acl_entry}
\alias{ec2_replace_network_acl_entry}
\title{Replaces an entry (rule) in a network ACL}
\usage{
ec2_replace_network_acl_entry(CidrBlock, DryRun, Egress, IcmpTypeCode,
  Ipv6CidrBlock, NetworkAclId, PortRange, Protocol, RuleAction,
  RuleNumber)
}
\arguments{
\item{CidrBlock}{The IPv4 network range to allow or deny, in CIDR notation (for example
\verb{172.16.0.0/24}).}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Egress}{[required] Indicates whether to replace the egress rule.

Default: If no value is specified, we replace the ingress rule.}

\item{IcmpTypeCode}{ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying
protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.}

\item{Ipv6CidrBlock}{The IPv6 network range to allow or deny, in CIDR notation (for example
\verb{2001:bd8:1234:1a00::/64}).}

\item{NetworkAclId}{[required] The ID of the ACL.}

\item{PortRange}{TCP or UDP protocols: The range of ports the rule applies to. Required
if specifying protocol 6 (TCP) or 17 (UDP).}

\item{Protocol}{[required] The protocol number. A value of \"-1\" means all protocols. If you
specify \"-1\" or a protocol number other than \"6\" (TCP), \"17\"
(UDP), or \"1\" (ICMP), traffic on all ports is allowed, regardless of
any ports or ICMP types or codes that you specify. If you specify
protocol \"58\" (ICMPv6) and specify an IPv4 CIDR block, traffic for all
ICMP types and codes allowed, regardless of any that you specify. If you
specify protocol \"58\" (ICMPv6) and specify an IPv6 CIDR block, you
must specify an ICMP type and code.}

\item{RuleAction}{[required] Indicates whether to allow or deny the traffic that matches the rule.}

\item{RuleNumber}{[required] The rule number of the entry to replace.}
}
\description{
Replaces an entry (rule) in a network ACL. For more information, see
\href{https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html}{Network ACLs} in
the \emph{Amazon Virtual Private Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$replace_network_acl_entry(
  CidrBlock = "string",
  DryRun = TRUE|FALSE,
  Egress = TRUE|FALSE,
  IcmpTypeCode = list(
    Code = 123,
    Type = 123
  ),
  Ipv6CidrBlock = "string",
  NetworkAclId = "string",
  PortRange = list(
    From = 123,
    To = 123
  ),
  Protocol = "string",
  RuleAction = "allow"|"deny",
  RuleNumber = 123
)
}
}

\examples{
\dontrun{
# This example replaces an entry for the specified network ACL. The new
# rule 100 allows ingress traffic from 203.0.113.12/24 on UDP port 53
# (DNS) into any associated subnet.
svc$replace_network_acl_entry(
  CidrBlock = "203.0.113.12/24",
  Egress = FALSE,
  NetworkAclId = "acl-5fb85d36",
  PortRange = list(
    From = 53L,
    To = 53L
  ),
  Protocol = "17",
  RuleAction = "allow",
  RuleNumber = 100L
)
}

}
\keyword{internal}
