% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_associate_enclave_certificate_iam_role}
\alias{ec2_associate_enclave_certificate_iam_role}
\title{Associates an Identity and Access Management (IAM) role with an
Certificate Manager (ACM) certificate}
\usage{
ec2_associate_enclave_certificate_iam_role(
  CertificateArn = NULL,
  RoleArn = NULL,
  DryRun = NULL
)
}
\arguments{
\item{CertificateArn}{The ARN of the ACM certificate with which to associate the IAM role.}

\item{RoleArn}{The ARN of the IAM role to associate with the ACM certificate. You can
associate up to 16 IAM roles with an ACM certificate.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate. This enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more information, see \href{https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html}{Certificate Manager for Nitro Enclaves} in the \emph{Amazon Web Services Nitro Enclaves User Guide}.

See \url{https://paws-r.github.io/docs/ec2/associate_enclave_certificate_iam_role.html} for full documentation.
}
\keyword{internal}
