% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_replace_root_volume_task}
\alias{ec2_create_replace_root_volume_task}
\title{Creates a root volume replacement task for an Amazon EC2 instance}
\usage{
ec2_create_replace_root_volume_task(
  InstanceId,
  SnapshotId = NULL,
  ClientToken = NULL,
  DryRun = NULL,
  TagSpecifications = NULL
)
}
\arguments{
\item{InstanceId}{[required] The ID of the instance for which to replace the root volume.}

\item{SnapshotId}{The ID of the snapshot from which to restore the replacement root
volume. If you want to restore the volume to the initial launch state,
omit this parameter.}

\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. If you do not specify a client token, a randomly
generated token is used for the request to ensure idempotency. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring idempotency}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{TagSpecifications}{The tags to apply to the root volume replacement task.}
}
\description{
Creates a root volume replacement task for an Amazon EC2 instance. The root volume can either be restored to its initial launch state, or it can be restored using a specific snapshot.

See \url{https://paws-r.github.io/docs/ec2/create_replace_root_volume_task.html} for full documentation.
}
\keyword{internal}
