% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_serial_console_access_status}
\alias{ec2_get_serial_console_access_status}
\title{Retrieves the access status of your account to the EC2 serial console of
all instances}
\usage{
ec2_get_serial_console_access_status(DryRun = NULL)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Retrieves the access status of your account to the EC2 serial console of all instances. By default, access to the EC2 serial console is disabled for your account. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configure-access-to-serial-console.html#serial-console-account-access}{Manage account access to the EC2 serial console} in the \emph{Amazon EC2 User Guide}.

See \url{https://paws-r.github.io/docs/ec2/get_serial_console_access_status.html} for full documentation.
}
\keyword{internal}
