% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emrcontainers_operations.R
\name{emrcontainers_list_managed_endpoints}
\alias{emrcontainers_list_managed_endpoints}
\title{Lists managed endpoints based on a set of parameters}
\usage{
emrcontainers_list_managed_endpoints(
  virtualClusterId,
  createdBefore = NULL,
  createdAfter = NULL,
  types = NULL,
  states = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{virtualClusterId}{[required] The ID of the virtual cluster.}

\item{createdBefore}{The date and time before which the endpoints are created.}

\item{createdAfter}{The date and time after which the endpoints are created.}

\item{types}{The types of the managed endpoints.}

\item{states}{The states of the managed endpoints.}

\item{maxResults}{The maximum number of managed endpoints that can be listed.}

\item{nextToken}{The token for the next set of managed endpoints to return.}
}
\description{
Lists managed endpoints based on a set of parameters. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.

See \url{https://paws-r.github.io/docs/emrcontainers/list_managed_endpoints.html} for full documentation.
}
\keyword{internal}
