% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_delete_load_balancer_tls_certificate}
\alias{lightsail_delete_load_balancer_tls_certificate}
\title{Deletes an SSL/TLS certificate associated with a Lightsail load balancer}
\usage{
lightsail_delete_load_balancer_tls_certificate(
  loadBalancerName,
  certificateName,
  force = NULL
)
}
\arguments{
\item{loadBalancerName}{[required] The load balancer name.}

\item{certificateName}{[required] The SSL/TLS certificate name.}

\item{force}{When \code{true}, forces the deletion of an SSL/TLS certificate.

There can be two certificates associated with a Lightsail load balancer:
the primary and the backup. The \code{force} parameter is required when the
primary SSL/TLS certificate is in use by an instance attached to the
load balancer.}
}
\description{
Deletes an SSL/TLS certificate associated with a Lightsail load balancer.

See \url{https://paws-r.github.io/docs/lightsail/delete_load_balancer_tls_certificate.html} for full documentation.
}
\keyword{internal}
